package jaxx.runtime.swing.config;

/*
 * #%L
 * JAXX :: Config
 * $Id: ConfigCategoryUIHandler.java 2783 2014-02-04 07:27:32Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.5/jaxx-config/src/main/java/jaxx/runtime/swing/config/ConfigCategoryUIHandler.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.model.ConfigTableModel;
import jaxx.runtime.swing.config.model.OptionModel;
import jaxx.runtime.swing.renderer.ClassTableCellRenderer;
import jaxx.runtime.swing.renderer.ColorCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import java.awt.Color;
import java.awt.Font;

import static org.nuiton.i18n.I18n.t;
import static org.nuiton.i18n.I18n.n;

/**
 * Handler of {@link ConfigCategoryUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.11
 */
public class ConfigCategoryUIHandler {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ConfigCategoryUIHandler.class);

    private final ConfigCategoryUI ui;

    public ConfigCategoryUIHandler(ConfigCategoryUI ui) {
        this.ui = ui;
    }

    public void init() {

        JTable table = ui.getTable();

        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(
                table,
                n("config.key"),
                n("config.key.tip"),
                n("config.value"),
                n("config.value.tip"),
                n("config.defaultValue"),
                n("config.defaultValue.tip"));

        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
        table.setDefaultRenderer(Color.class, new ColorCellRenderer());
        table.setDefaultRenderer(Class.class, new ClassTableCellRenderer());
    }

    public void updateDescriptionText() {
        OptionModel option;
        JTable table = ui.getTable();
        JTextArea description = ui.getDescription();
        ListSelectionModel selectionModel = ui.getSelectionModel();

        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(t("config.no.option.selected"));
        } else {
            buffer.append(t("config.option.label", option.getKey(), t(option.getDescription()))).append('\n');
            if (option.isModified()) {
                String oValue = option.toString(option.getOriginalValue());
                String mValue = option.toString(option.getValue());
                buffer.append(t("config.option.modified", oValue, mValue)).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(t("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }

}
