/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.types;

import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.types.TypeConverter;

public class PrimitiveConverter
implements TypeConverter {
    @Override
    public Class<?>[] getSupportedTypes() {
        return new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, String.class};
    }

    @Override
    public String getJavaCode(Object object) {
        if (object instanceof Boolean) {
            return String.valueOf((Boolean)object);
        }
        if (object instanceof Byte) {
            return String.valueOf(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return String.valueOf(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return String.valueOf((Integer)object);
        }
        if (object instanceof Long) {
            return String.valueOf((Long)object) + "L";
        }
        if (object instanceof Float) {
            return String.valueOf(((Float)object).floatValue()) + "F";
        }
        if (object instanceof Double) {
            return String.valueOf((Double)object);
        }
        if (object instanceof String) {
            return '\"' + JAXXCompiler.escapeJavaString((String)object) + '\"';
        }
        throw new IllegalArgumentException("unsupported object: " + object);
    }

    @Override
    public Object convertFromString(String string, Class<?> type) {
        if (String.class.equals(type) || Object.class.equals(type) || type == null) {
            return string;
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.valueOf(string);
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            if (string.toLowerCase().equals("true")) {
                return Boolean.TRUE;
            }
            if (string.toLowerCase().equals("false")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("expected 'true' or 'false', found '" + string + "'");
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return Byte.valueOf(string);
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return Short.valueOf(string);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.valueOf(string);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(string);
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.valueOf(string);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            throw new IllegalArgumentException("expected a single character, found '" + string + "'");
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }
}

