/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerException;
import jaxx.compiler.I18nHelper;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.beans.JAXXBeanInfo;
import jaxx.compiler.beans.JAXXEventSetDescriptor;
import jaxx.compiler.beans.JAXXIntrospector;
import jaxx.compiler.beans.JAXXPropertyDescriptor;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.css.StylesheetHelper;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.TagHandler;
import jaxx.compiler.tags.TagManager;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.ComponentDescriptor;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.bean.BeanTypeAware;
import jaxx.runtime.css.Stylesheet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultObjectHandler
implements TagHandler {
    private static final Log log = LogFactory.getLog(DefaultObjectHandler.class);
    public static final String HANDLER_ATTRIBUTE = "handler";
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String CONSTRAINTS_ATTRIBUTE = "constraints";
    public static final String CONSTRUCTOR_PARAMS_ATTRIBUTE = "constructorParams";
    public static final String DECORATOR_ATTRIBUTE = "decorator";
    public static final String DISPLAYED_MNEMONIC_ATTRIBUTE = "displayedMnemonic";
    public static final String DISPLAYED_MNEMONIC_INDEX_ATTRIBUTE = "displayedMnemonicIndex";
    public static final String GENERIC_TYPE_ATTRIBUTE = "genericType";
    public static final String ID_ATTRIBUTE = "id";
    public static final String IMPLEMENTS_ATTRIBUTE = "implements";
    public static final String INITIALIZER_ATTRIBUTE = "initializer";
    public static final String JAVA_BEAN_ATTRIBUTE = "javaBean";
    public static final String LAYOUT_ATTRIBUTE = "layout";
    public static final String MNEMONIC_ATTRIBUTE = "mnemonic";
    public static final String STYLE_CLASS_ATTRIBUTE = "styleClass";
    public static final String SUPER_GENERIC_TYPE_ATTRIBUTE = "superGenericType";
    public static final String GRID_LAYOUT_PREFIX = GridLayout.class.getSimpleName() + "(";
    public static final String BORDER_LAYOUT_PREFIX = BorderLayout.class.getSimpleName() + "(";
    private ClassDescriptor beanClass;
    protected JAXXBeanInfo jaxxBeanInfo;
    private Map<String, JAXXPropertyDescriptor> properties;
    private Map<String, JAXXEventSetDescriptor> events;
    private Map<String, ProxyEventInfo> eventInfos;
    protected static Map<Element, CompiledObject> objectMap = new WeakHashMap<Element, CompiledObject>();

    public ProxyEventInfo getEventInfo(String memberName) {
        return this.eventInfos != null ? this.eventInfos.get(memberName) : null;
    }

    public DefaultObjectHandler(ClassDescriptor beanClass) {
        this.beanClass = beanClass;
    }

    protected void init() throws IntrospectionException {
        if (this.jaxxBeanInfo == null) {
            this.jaxxBeanInfo = DefaultObjectHandler.getJAXXBeanInfo(this.beanClass);
            JAXXPropertyDescriptor[] propertiesArray = this.jaxxBeanInfo.getJAXXPropertyDescriptors();
            this.properties = new HashMap<String, JAXXPropertyDescriptor>();
            for (int i = propertiesArray.length - 1; i >= 0; --i) {
                this.properties.put(propertiesArray[i].getName(), propertiesArray[i]);
            }
            JAXXEventSetDescriptor[] eventsArray = this.jaxxBeanInfo.getJAXXEventSetDescriptors();
            this.events = new HashMap<String, JAXXEventSetDescriptor>();
            for (int i = eventsArray.length - 1; i >= 0; --i) {
                MethodDescriptor[] methods;
                for (MethodDescriptor method : methods = eventsArray[i].getListenerMethods()) {
                    this.events.put(method.getName(), eventsArray[i]);
                }
            }
            this.configureProxyEventInfo();
        }
    }

    public ClassDescriptor getBeanClass() {
        return this.beanClass;
    }

    public JAXXBeanInfo getJAXXBeanInfo() {
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return this.jaxxBeanInfo;
    }

    public static JAXXBeanInfo getJAXXBeanInfo(ClassDescriptor beanClass) throws IntrospectionException {
        return JAXXIntrospector.getJAXXBeanInfo(beanClass);
    }

    public ClassDescriptor getPropertyType(CompiledObject object, String propertyName, JAXXCompiler compiler) {
        this.safeInit();
        JAXXPropertyDescriptor property = this.properties.get(propertyName);
        if (property != null) {
            return property.getPropertyType();
        }
        throw new UnsupportedAttributeException("property '" + propertyName + "' not found in " + object);
    }

    public boolean isMemberBound(String name) throws UnsupportedAttributeException {
        JAXXPropertyDescriptor property;
        this.safeInit();
        if (this.eventInfos != null && this.eventInfos.containsKey(name)) {
            return true;
        }
        if (name.equals("getClass")) {
            return false;
        }
        String propertyName = null;
        if (name.startsWith("get")) {
            propertyName = Introspector.decapitalize(name.substring("get".length()));
        } else if (name.startsWith("is")) {
            propertyName = Introspector.decapitalize(name.substring("is".length()));
        }
        JAXXPropertyDescriptor jAXXPropertyDescriptor = property = propertyName != null ? this.properties.get(propertyName) : null;
        if (property != null) {
            return property.isBound();
        }
        try {
            FieldDescriptor field = this.getBeanClass().getFieldDescriptor(name);
            return Modifier.isFinal(field.getModifiers());
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedAttributeException("cannot find property '" + name + "' of " + this.getBeanClass());
        }
    }

    public static ClassDescriptor getEventClass(ClassDescriptor listenerClass) {
        return listenerClass.getMethodDescriptors()[0].getParameterTypes()[0];
    }

    protected void configureProxyEventInfo() {
    }

    public void addProxyEventInfo(String memberName, Class<?> listenerClass) {
        this.addProxyEventInfo(memberName, listenerClass, null);
    }

    public void addProxyEventInfo(String memberName, Class<?> listenerClass, String modelName) {
        String listenerName = listenerClass.getName();
        listenerName = listenerName.substring(listenerName.lastIndexOf(".") + 1);
        this.addProxyEventInfo(memberName, listenerClass, modelName, "add" + listenerName, "remove" + listenerName);
    }

    public void addProxyEventInfo(String memberName, Class<?> listenerClass, String modelName, String addMethod, String removeMethod) {
        try {
            ClassDescriptor classDescriptor = ClassDescriptorHelper.getClassDescriptor(listenerClass.getName());
            this.addProxyEventInfo(memberName, classDescriptor, modelName, addMethod, removeMethod);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addProxyEventInfo(String memberName, ClassDescriptor listenerClass, String modelName, String addMethod, String removeMethod) {
        ProxyEventInfo info = new ProxyEventInfo();
        info.memberName = memberName;
        info.listenerClass = listenerClass;
        info.modelName = modelName;
        info.addMethod = addMethod;
        info.removeMethod = removeMethod;
        if (this.eventInfos == null) {
            this.eventInfos = new HashMap<String, ProxyEventInfo>();
        }
        this.eventInfos.put(memberName, info);
    }

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.scanAttributesForDependencies(tag, compiler);
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.safeInit();
        CompiledObject object = objectMap.get(tag);
        if (object == null) {
            throw new IllegalStateException("unable to find CompiledObject associated with tag <" + tag.getTagName() + ">;  should have been registered " + "before second pass");
        }
        compiler.checkOverride(object);
        String constructorParams = tag.getAttribute(CONSTRUCTOR_PARAMS_ATTRIBUTE);
        if (StringUtils.isNotEmpty((CharSequence)constructorParams)) {
            object.setConstructorParams(compiler.getScriptManager().trimScript(constructorParams));
        }
        this.setDefaults(object, tag, compiler);
        this.setAttributes(object, tag, compiler);
        this.compileChildrenSecondPass(tag, compiler);
    }

    public void registerCompiledObject(Element tag, JAXXCompiler compiler) {
        String id = tag.getAttribute(ID_ATTRIBUTE);
        if (id == null || id.length() == 0) {
            id = compiler.getAutoId(this.getBeanClass().getSimpleName());
        }
        CompiledObject object = this.createCompiledObject(id, compiler);
        objectMap.put(tag, object);
        String styleClass = tag.getAttribute(STYLE_CLASS_ATTRIBUTE).trim();
        if (styleClass.length() > 0) {
            object.setStyleClass(styleClass);
        }
        compiler.registerCompiledObject(object);
    }

    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) {
        return new CompiledObject(id, this.getBeanClass(), compiler);
    }

    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) {
    }

    public boolean isPropertyInherited(String property) throws UnsupportedAttributeException {
        return false;
    }

    public boolean isEventHandlerName(String name) {
        return name.length() > 2 && name.startsWith("on") && Character.isUpperCase(name.charAt(2));
    }

    protected void scanAttributesForDependencies(Element tag, JAXXCompiler compiler) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            attributes.add((Attr)children.item(i));
        }
        Collections.sort(attributes, this.getAttributeComparator());
        for (Attr attribute : attributes) {
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.equals(JAVA_BEAN_ATTRIBUTE)) continue;
            if (name.equals(CONSTRAINTS_ATTRIBUTE) || this.isEventHandlerName(name)) {
                compiler.preprocessScript(value);
                continue;
            }
            if (name.equals(CONSTRUCTOR_PARAMS_ATTRIBUTE)) {
                compiler.preprocessScript("java.util.Arrays.toString(" + value + ")");
                continue;
            }
            if (!value.startsWith("{") || !value.endsWith("}")) continue;
            compiler.preprocessScript(value.substring(1, value.length() - 1));
        }
    }

    public void setAttributes(CompiledObject object, Element tag, JAXXCompiler compiler) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            attributes.add((Attr)children.item(i));
        }
        Collections.sort(attributes, this.getAttributeComparator());
        CompiledObject rootObject = compiler.getRootObject();
        Attr genericTypeAttribute = null;
        for (Attr attribute : attributes) {
            String name = attribute.getName();
            String value = attribute.getValue().trim();
            if (name.equals(ID_ATTRIBUTE) || name.equals(CONSTRAINTS_ATTRIBUTE) || name.equals(CONSTRUCTOR_PARAMS_ATTRIBUTE) || name.equals(STYLE_CLASS_ATTRIBUTE) || name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI()) || compiler.isUseHandler() && name.startsWith(HANDLER_ATTRIBUTE)) continue;
            if (name.equals(JAVA_BEAN_ATTRIBUTE)) {
                object.setJavaBean(true);
                if (value.isEmpty()) continue;
                object.setJavaBeanInitCode(value);
                continue;
            }
            if (name.equals(INITIALIZER_ATTRIBUTE)) {
                if (!value.isEmpty()) {
                    object.setInitializer(value);
                    continue;
                }
                object.setInitializer("null");
                continue;
            }
            if (name.equals(IMPLEMENTS_ATTRIBUTE)) {
                if (object != rootObject) {
                    compiler.reportError("'implements' attribute can only be found on root tag but was found on tag " + tag);
                    return;
                }
                String[] interfaces = compiler.getSymbolTable().getInterfaces();
                compiler.setExtraInterfaces(interfaces);
                continue;
            }
            if (name.equals(ABSTRACT_ATTRIBUTE)) {
                if (object != rootObject) {
                    compiler.reportError("'abstract' attribute can only be found on root tag but was found on tag " + tag);
                    return;
                }
                compiler.setAbstractClass(true);
                continue;
            }
            if (name.equals(GENERIC_TYPE_ATTRIBUTE)) {
                genericTypeAttribute = attribute;
                continue;
            }
            if (name.equals(SUPER_GENERIC_TYPE_ATTRIBUTE)) {
                if (object != rootObject) {
                    compiler.reportError("'superGenericType' attribute can only be found on root tag but was found on tag " + tag);
                    return;
                }
                compiler.setSuperGenericType(value);
                continue;
            }
            if (name.equals(DECORATOR_ATTRIBUTE)) {
                if (value.isEmpty()) continue;
                CompiledObjectDecorator decorator = compiler.getEngine().getDecorator(value);
                object.setDecorator(decorator);
                continue;
            }
            if (this.isEventHandlerName(name)) {
                if (!value.endsWith(";") && !value.endsWith("}")) {
                    value = value + ";";
                }
                this.addEventHandler(object, Introspector.decapitalize(name.substring(2)), value, compiler);
                continue;
            }
            this.setAttribute(object, name, value, true, compiler);
        }
        if (genericTypeAttribute != null) {
            String fqn;
            String name = genericTypeAttribute.getName();
            String value = genericTypeAttribute.getValue().trim();
            if (object == rootObject) {
                compiler.setGenericType(value);
            } else {
                object.setGenericTypes(value.split(","));
                if (object.getSimpleType() != null) {
                    object.setSimpleType(object.getSimpleType() + "<" + value + ">");
                }
            }
            if (ClassDescriptorHelper.getClassDescriptor(BeanTypeAware.class).isAssignableFrom(object.getObjectClass()) && (fqn = compiler.getImportedTypeForSimpleName(value)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add beanType property: " + value + " to " + object));
                }
                this.setAttribute(object, "beanType", "{" + value + ".class}", true, compiler);
            }
        }
    }

    protected Comparator<Attr> getAttributeComparator() {
        return new Comparator<Attr>(){

            @Override
            public int compare(Attr a, Attr b) {
                int aOrder = DefaultObjectHandler.this.getAttributeOrdering(a);
                int bOrder = DefaultObjectHandler.this.getAttributeOrdering(b);
                return aOrder - bOrder;
            }
        };
    }

    protected int getAttributeOrdering(Attr attr) {
        if (attr.getName().equals(DISPLAYED_MNEMONIC_INDEX_ATTRIBUTE) || attr.getName().equals(DISPLAYED_MNEMONIC_ATTRIBUTE) || attr.getName().equals(MNEMONIC_ATTRIBUTE)) {
            return 1;
        }
        return 0;
    }

    public void setAttributeFromCss(CompiledObject object, String propertyName, String stringValue, JAXXCompiler compiler) {
        try {
            boolean withBinding;
            object.addProperty(propertyName, stringValue);
            ClassDescriptor type = this.getPropertyType(object, propertyName, compiler);
            String binding = DataBindingHelper.processDataBindings(stringValue);
            boolean bl = withBinding = binding != null;
            if (!withBinding) {
                if (I18nHelper.isI18nableAttribute(propertyName, compiler)) {
                    stringValue = I18nHelper.addI18nInvocation(object.getId(), propertyName, stringValue, compiler);
                }
                try {
                    Class<?> typeClass = type != null ? ClassDescriptorHelper.getClass(type.getName(), type.getClassLoader()) : null;
                    Object value = this.convertFromString(propertyName, stringValue, typeClass);
                    this.setProperty(object, propertyName, value, compiler);
                    return;
                }
                catch (NumberFormatException e) {
                    compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
                }
                catch (IllegalArgumentException e) {
                    compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
                }
                catch (ClassNotFoundException e) {
                    compiler.reportError("could not find class " + type.getName());
                }
            }
            String setPropertyCode = this.getSetPropertyCode(object.getJavaCode(), propertyName, binding, compiler);
            if (propertyName.equals(LAYOUT_ATTRIBUTE)) {
                if (setPropertyCode.contains(BORDER_LAYOUT_PREFIX)) {
                    compiler.addImport(BorderLayout.class);
                } else if (setPropertyCode.contains(GRID_LAYOUT_PREFIX)) {
                    compiler.addImport(GridLayout.class);
                }
                object.appendInitializationCode(setPropertyCode);
            }
            compiler.getBindingHelper().registerDataBinding(object.getId() + "." + propertyName, binding, setPropertyCode);
        }
        catch (UnsupportedAttributeException e) {
            compiler.reportError("class " + object.getObjectClass().getName() + " does not support attribute '" + propertyName + "'");
        }
    }

    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        try {
            boolean withBinding;
            object.addProperty(propertyName, stringValue);
            ClassDescriptor type = this.getPropertyType(object, propertyName, compiler);
            String binding = DataBindingHelper.processDataBindings(stringValue);
            boolean bl = withBinding = binding != null;
            if (inline) {
                compiler.addInlineStyle(object, propertyName, withBinding);
            }
            if (!withBinding) {
                try {
                    Class<?> typeClass = type != null ? ClassDescriptorHelper.getClass(type.getName(), type.getClassLoader()) : null;
                    Object value = this.convertFromString(propertyName, stringValue, typeClass);
                    this.setProperty(object, propertyName, value, compiler);
                    return;
                }
                catch (NumberFormatException e) {
                    compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
                }
                catch (IllegalArgumentException e) {
                    compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
                }
                catch (ClassNotFoundException e) {
                    compiler.reportError("could not find class " + type.getName());
                }
            }
            String setPropertyCode = this.getSetPropertyCode(object.getJavaCode(), propertyName, binding, compiler);
            if (propertyName.equals(LAYOUT_ATTRIBUTE)) {
                if (setPropertyCode.contains(BORDER_LAYOUT_PREFIX)) {
                    compiler.addImport(BorderLayout.class);
                } else if (setPropertyCode.contains(GRID_LAYOUT_PREFIX)) {
                    compiler.addImport(GridLayout.class);
                }
                object.appendInitializationCode(setPropertyCode);
            }
            compiler.getBindingHelper().registerDataBinding(object.getId() + "." + propertyName, binding, setPropertyCode);
        }
        catch (UnsupportedAttributeException e) {
            compiler.reportError("class " + object.getObjectClass().getName() + " does not support attribute '" + propertyName + "'");
        }
    }

    public void applyStylesheets(CompiledObject object, JAXXCompiler compiler) {
        this.applyStylesheets(object, compiler, null);
    }

    private void applyStylesheets(CompiledObject object, JAXXCompiler compiler, Stylesheet overrides) {
        this.applyStylesheets(object, compiler, overrides, true);
    }

    private void applyStylesheets(CompiledObject object, JAXXCompiler compiler, Stylesheet overrides, boolean recurse) {
        Stylesheet stylesheet = compiler.getStylesheet();
        ClassDescriptor objectClass = object.getObjectClass();
        ClassDescriptor jaxxObjectClassDescriptor = ClassDescriptorHelper.getClassDescriptor(JAXXObject.class);
        boolean applyInside = recurse && jaxxObjectClassDescriptor.isAssignableFrom(objectClass) && compiler.getConfiguration().isAutoRecurseInCss();
        try {
            ComponentDescriptor[] descriptors;
            if (!applyInside) {
                if (stylesheet != null) {
                    StylesheetHelper.applyTo(object, compiler, stylesheet, overrides);
                }
                return;
            }
            JAXXObjectDescriptor jaxxObjectDescriptor = objectClass.getJAXXObjectDescriptor();
            for (ComponentDescriptor descriptor : descriptors = jaxxObjectDescriptor.getComponentDescriptors()) {
                ClassDescriptor classDescriptor = ClassDescriptorHelper.getClassDescriptor(descriptor.getJavaClassName());
                boolean isRoot = classDescriptor != objectClass;
                String id = isRoot ? object.getId() + ' ' + descriptor.getId() : "( " + object.getId() + " ) " + descriptor.getId();
                CompiledObject child = new CompiledObject(id, "((" + JAXXCompiler.getCanonicalName(classDescriptor) + ") " + object.getJavaCode() + ".getObjectById(" + TypeManager.getJavaCode(descriptor.getId()) + "))", classDescriptor, compiler, true);
                CompiledObject currentObject = child;
                for (ComponentDescriptor parentDescriptor = descriptor.getParent(); parentDescriptor != null; parentDescriptor = parentDescriptor.getParent()) {
                    CompiledObject parent = new CompiledObject("internal", ClassDescriptorHelper.getClassDescriptor(parentDescriptor.getJavaClassName()), compiler);
                    currentObject.setParent(parent);
                    currentObject = parent;
                }
                currentObject.setParent(object);
                String styleClass = object.getStyleClass();
                if (styleClass == null) {
                    styleClass = descriptor.getStyleClass();
                }
                child.setStyleClass(styleClass);
                Stylesheet mergedStylesheet = overrides;
                Stylesheet childOverrides = jaxxObjectDescriptor.getStylesheet();
                if (childOverrides != null) {
                    if (mergedStylesheet == null) {
                        mergedStylesheet = childOverrides;
                    } else {
                        mergedStylesheet.add(childOverrides.getRules());
                    }
                }
                TagManager.getTagHandler(objectClass).applyStylesheets(child, compiler, mergedStylesheet, isRoot);
                object.appendInitializationCode(child.getInitializationCode(compiler));
            }
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException(e);
        }
        catch (IllegalArgumentException e) {
            compiler.reportError(e.getMessage());
        }
    }

    public void addEventHandler(CompiledObject object, String name, String value, JAXXCompiler compiler) {
        JAXXEventSetDescriptor descriptorSet = this.events.get(name);
        if (descriptorSet != null) {
            MethodDescriptor[] listenerMethods = descriptorSet.getListenerMethods();
            MethodDescriptor listenerMethod = null;
            for (MethodDescriptor listenerMethod1 : listenerMethods) {
                if (!listenerMethod1.getName().equals(name)) continue;
                listenerMethod = listenerMethod1;
                break;
            }
            if (listenerMethod == null) {
                throw new RuntimeException("expected to find method '" + name + "' in JAXXEventSetDescriptor.getListenerMethods()");
            }
            try {
                value = compiler.preprocessScript(value);
                object.addEventHandler(name, descriptorSet.getAddListenerMethod(), listenerMethod, value, compiler);
            }
            catch (CompilerException e) {
                compiler.reportError("While parsing event handler for '" + name + "': " + e.getMessage());
            }
        } else {
            compiler.reportError("could not find event '" + name + "' for object " + object);
        }
    }

    public String getGetPropertyCode(String javaCode, String name, JAXXCompiler compiler) {
        this.safeInit();
        JAXXPropertyDescriptor property = this.properties.get(name);
        if (property != null) {
            if (property.getReadMethodDescriptor() != null) {
                return javaCode + '.' + property.getReadMethodDescriptor().getName() + "()";
            }
            throw new UnsupportedAttributeException("property '" + name + "' of " + this.getBeanClass().getName() + " has no read method");
        }
        throw new UnsupportedAttributeException("property '" + name + "' could not be found in class " + this.getBeanClass().getName());
    }

    public String getSetPropertyCode(String javaCode, String name, String valueCode, JAXXCompiler compiler) {
        JAXXPropertyDescriptor property = this.properties.get(name);
        if (property != null) {
            if (property.getWriteMethodDescriptor() != null) {
                String prefix = compiler.getRootObject().getJavaCode().equals(javaCode) ? "" : javaCode + ".";
                return prefix + property.getWriteMethodDescriptor().getName() + '(' + valueCode + ");";
            }
            throw new UnsupportedAttributeException("property '" + name + "' of " + this.getBeanClass().getName() + " is read-only");
        }
        throw new UnsupportedAttributeException("property '" + name + "' could not be found in class " + this.getBeanClass().getName());
    }

    public void setProperty(CompiledObject object, String name, Object value, JAXXCompiler compiler) {
        object.appendInitializationCode(this.getSetPropertyCode(object.getJavaCodeForProperty(name), name, TypeManager.getJavaCode(value), compiler));
    }

    protected int constantValue(String key, String value) {
        JAXXBeanInfo JAXXBeanInfo2 = this.getJAXXBeanInfo();
        JAXXPropertyDescriptor[] props = JAXXBeanInfo2.getJAXXPropertyDescriptors();
        String lowercaseValue = value.toLowerCase();
        for (JAXXPropertyDescriptor property : props) {
            Object[] values;
            if (!property.getName().equals(key) || (values = (Object[])property.getValue("enumerationValues")) == null) continue;
            for (int j = 0; j < values.length - 2; j += 3) {
                if (!((String)values[j]).toLowerCase().equals(lowercaseValue)) continue;
                return (Integer)values[j + 1];
            }
            StringBuilder message = new StringBuilder("value of '" + key + "' must be one of: [");
            for (int j = 0; j < values.length - 2; j += 3) {
                if (j != 0) {
                    message.append(", ");
                }
                message.append(((String)values[j]).toLowerCase());
            }
            message.append("] (found '").append(value).append("')");
            throw new IllegalArgumentException(message.toString());
        }
        throw new NumberFormatException(value);
    }

    protected Object convertFromString(String key, String value, Class<?> type) {
        if (type == null || Object.class.equals(type)) {
            return value;
        }
        try {
            return TypeManager.convertFromString(value, type);
        }
        catch (NumberFormatException e) {
            if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                return this.constantValue(key, value);
            }
            throw e;
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            Element child = (Element)node;
            this.compileChildTagFirstPass(child, compiler);
        }
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBeanClass().getName() + "]";
    }

    protected void safeInit() {
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ProxyEventInfo {
        String memberName;
        ClassDescriptor listenerClass;
        String modelName;
        String addMethod;
        String removeMethod;

        public String getAddMethod() {
            return this.addMethod;
        }

        public ClassDescriptor getListenerClass() {
            return this.listenerClass;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getRemoveMethod() {
            return this.removeMethod;
        }
    }
}

