/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: ProfileTask.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.5/jaxx-compiler/src/main/java/jaxx/compiler/tasks/ProfileTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.JAXXEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * A task to display result of profile mode
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class ProfileTask extends JAXXEngineTask {

    /** Logger */
    private static final Log log = LogFactory.getLog(ProfileTask.class);

    /** Task name */
    public static final String TASK_NAME = "Profile";

    public ProfileTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        StringBuilder buffer = engine.getProfiler().computeProfileReport();
        log.info(buffer.toString());
        return success;
    }
}