/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: StyleHandler.java 2228 2011-02-19 21:56:44Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.23/jaxx-compiler/src/main/java/jaxx/compiler/tags/StyleHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.tags;

import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.css.StylesheetHelper;
import jaxx.runtime.css.Stylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import java.io.File;
import java.io.IOException;

/**
 * Handles the <code>&lt;style&gt;</code> tag.
 *
 * @author Ethan Nicholas
 */
public class StyleHandler implements TagHandler {

    public static final String TAG_NAME = "style";

    public static final String SOURCE_ATTRIBUTE = "source";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        boolean source = false;
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); i++) {
            Attr attribute = (Attr) attributes.item(i);
            String name = attribute.getName();
            String attrValue = attribute.getValue();
            if (name.equals(SOURCE_ATTRIBUTE)) {
                source = true;
                File styleFile = new File(compiler.getBaseDir(), attrValue.replace('/', File.separatorChar));
                if (!styleFile.exists()) {
                    compiler.reportError("stylesheet file not found: " + styleFile);
                } else {
                    compiler.registerStyleSheetFile(styleFile);
                }
//                StringWriter styleBuffer = new StringWriter();
//                FileReader in = new FileReader(styleFile);
//                try {
//                    char[] readBuffer = new char[2048];
//                    int c;
//                    while ((c = in.read(readBuffer)) > 0) {
//                        styleBuffer.write(readBuffer, 0, c);
//                    }
//                } catch (FileNotFoundException e) {
//                    compiler.reportError("stylesheet file not found: " + styleFile);
//                } finally {
//                    in.close();
//                }
//                compiler.getSourceFiles().push(styleFile);
//                compiler.registerStylesheet(StylesheetHelper.processStylesheet(styleBuffer.toString()));
//                compiler.getSourceFiles().pop();
            } else if (!name.startsWith(XMLNS_ATTRIBUTE) &&
                    !JAXXCompiler.JAXX_INTERNAL_NAMESPACE.equals(attribute.getNamespaceURI())) {
                throw new UnsupportedAttributeException(name);
            }
        }

        StringBuilder style = new StringBuilder();
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); i++) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case Node.ELEMENT_NODE:
                    compiler.reportError("<style> tag may not contain child elements: " + tag);
                case Node.TEXT_NODE: // fall through
                case Node.CDATA_SECTION_NODE:
                    style.append(((Text) child).getData());
            }
        }

        String styleString = style.toString().trim();
        if (styleString.length() > 0) {
            if (source) {
                compiler.reportError("<style> tag has both a source attribute and an inline stylesheet");
            }
            Stylesheet stylesheet =
                    StylesheetHelper.processStylesheet(style.toString());
            compiler.registerStylesheet(stylesheet);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
    }

}
