/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: SimpleJAXXObjectBindingWriter.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.13/jaxx-compiler/src/main/java/jaxx/compiler/binding/writers/SimpleJAXXObjectBindingWriter.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.binding.writers;

import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DataListener;
import jaxx.compiler.binding.JavaParserUtil;
import jaxx.compiler.finalizers.DefaultFinalizer;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;

import java.lang.reflect.Modifier;
import java.util.List;

/**
 * Created: 5 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Revision: 2225 $
 *          <p/>
 *          Mise a jour: $Date: 2011-02-19 21:15:00 +0100 (Sat, 19 Feb 2011) $ par :
 *          $Author: tchemit $
 */
public class SimpleJAXXObjectBindingWriter extends AbstractJAXXBindingWriter<SimpleJAXXObjectBinding> {

    protected boolean used;

    public SimpleJAXXObjectBindingWriter() {
        super(SimpleJAXXObjectBinding.class);
    }

    @Override
    public boolean accept(DataBinding binding) {
        DataListener[] trackers = binding.getTrackers();
        if (trackers.length > 0) {
            for (DataListener tracker : trackers) {
                if (tracker.getObjectCode() != null) {
                    // tracker must be without any requirement
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected String getConstructorParams(DataBinding binding,
                                          DataListener[] trackers) {

        StringBuilder addBuffer = new StringBuilder();
        addBuffer.append("this, ");
        addBuffer.append(binding.getConstantId());
        addBuffer.append(", true");

        for (DataListener tracker : trackers) {
            String symbol = tracker.getSymbol();
            String name = symbol.substring(symbol.indexOf(".") + 1);
            if (JavaParserUtil.getMethodInvocationParameters(name) != null) {
                // obtain the property name from the method name
                name = JavaParserUtil.getPropertyNameFromMethod(name);
            }
            addBuffer.append(" ,\"").append(name).append("\"");
        }
        return addBuffer.toString();
    }

    @Override
    public void write(DataBinding binding,
                      JavaFileGenerator generator,
                      StringBuilder buffer) {
        DataListener[] trackers = binding.getTrackers();
        List<JavaMethod> bMethods = binding.getMethods();

        JavaMethod method = JavaElementFactory.newMethod(
                Modifier.PUBLIC,
                JAXXCompilerFinalizer.TYPE_VOID,
                DefaultFinalizer.METHOD_NAME_PROCESS_DATA_BINDING,
                binding.getProcessDataBinding(),
                true
        );

        bMethods.add(0, method);

        writeInvocationMethod(binding, trackers, generator, buffer, bMethods);
    }
}