/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jaxx.compiler.JAXXCompiler;
import org.nuiton.util.StringUtil;

public class JAXXProfile {
    SortedMap<Integer, CompilerEntry> entries;
    List<JAXXCompiler> compilers = new ArrayList<JAXXCompiler>();
    public static final String TIME_PATTERN = "%1$9s - %2$2d%%";

    void clear() {
        this.entries.clear();
        this.compilers.clear();
    }

    public JAXXProfile() {
        this.entries = new TreeMap<Integer, CompilerEntry>();
    }

    public void addTime(JAXXCompiler compiler, String key) {
        CompilerEntry e = this.getEntry(compiler);
        e.times.put(key, System.nanoTime());
    }

    public Map<JAXXCompiler, Long> getDelta(String keyOne, String keyTwo) {
        HashMap<JAXXCompiler, Long> result = new HashMap<JAXXCompiler, Long>();
        for (Map.Entry<Integer, CompilerEntry> e : this.entries.entrySet()) {
            JAXXCompiler c = this.getCompiler(e.getKey());
            CompilerEntry entry = e.getValue();
            Long t0 = (Long)entry.times.get(keyOne);
            Long t1 = (Long)entry.times.get(keyTwo);
            if (t0 == null) {
                throw new NullPointerException("could not find time for " + keyOne + " on compiler " + c.getOutputClassName());
            }
            if (t1 == null) {
                throw new NullPointerException("could not find time for " + keyTwo + " on compiler " + c.getOutputClassName());
            }
            long delta = t1 - t0;
            result.put(c, delta);
        }
        return result;
    }

    public ProfileResult newProfileResult(String name) {
        Map<JAXXCompiler, Long> delta = this.getDelta(name + "_start", name + "_end");
        ProfileResult result = new ProfileResult(delta);
        return result;
    }

    public ProfileResult newProfileResult(ProfileResult ... toCumul) {
        HashMap<JAXXCompiler, Long> delta = new HashMap<JAXXCompiler, Long>();
        for (JAXXCompiler c : this.compilers) {
            long total = 0L;
            for (ProfileResult cumul : toCumul) {
                long time = cumul.getTime(c);
                total += time;
            }
            delta.put(c, total);
        }
        ProfileResult result = new ProfileResult(delta);
        return result;
    }

    public StringBuilder computeProfileReport() {
        StringBuilder buffer = new StringBuilder();
        if (this.compilers.isEmpty()) {
            return buffer.append("no jaxx file treated, no profile report");
        }
        int maxLength = 0;
        for (JAXXCompiler compiler : this.compilers) {
            int l = compiler.getOutputClassName().length();
            if (l <= maxLength) continue;
            maxLength = l;
        }
        ProfileResult cfp = this.newProfileResult("CompileFirstPass");
        ProfileResult csp = this.newProfileResult("CompileSecondPass");
        ProfileResult ssp = this.newProfileResult("StyleSheet");
        ProfileResult fp = this.newProfileResult("Finalize");
        ProfileResult gp = this.newProfileResult("Generate");
        ProfileResult total = this.newProfileResult(cfp, csp, ssp, fp, gp);
        String reportPattern = "\n|%1$-" + maxLength + "s|%2$15s|%3$15s|%4$15s|%5$15s|%6$15s|%7$15s|";
        char[] tmpC = new char[maxLength];
        Arrays.fill(tmpC, '-');
        String line = String.format(reportPattern, new String(tmpC), "---------------", "---------------", "---------------", "---------------", "---------------", "---------------");
        buffer.append(line);
        buffer.append(String.format(reportPattern, "(files / stats) \\ passes", "compile round 1", "compile round 2", "stylesheet", "finalize", "generation", "all passes"));
        buffer.append(line);
        for (Long l : total.times) {
            JAXXCompiler c = total.getCompiler(l);
            this.printReportLine(buffer, reportPattern, c.getOutputClassName(), cfp.getTime(c), csp.getTime(c), ssp.getTime(c), fp.getTime(c), gp.getTime(c), total.getTime(c));
        }
        buffer.append(line);
        if (this.compilers.size() > 1) {
            this.printReportLine(buffer, reportPattern, "total (" + this.compilers.size() + " files)", cfp.total, csp.total, ssp.total, fp.total, gp.total, total.total);
            buffer.append(line);
            this.printReportLine2(buffer, reportPattern, "min", cfp.min, csp.min, ssp.min, fp.min, gp.min, total.min);
            this.printReportLine2(buffer, reportPattern, "max", cfp.max, csp.max, ssp.max, fp.max, gp.max, total.max);
            this.printReportLine(buffer, reportPattern, "average", cfp.average, csp.average, ssp.average, fp.average, gp.average, total.average);
            buffer.append(line);
        }
        cfp.clear();
        csp.clear();
        ssp.clear();
        gp.clear();
        total.clear();
        return buffer;
    }

    protected void printReportLine(StringBuilder buffer, String reportPattern, String label, long firstPassCounter, long secondPassCounter, long cssCounter, long finalizeCounter, long generatorCounter, long totalCounter) {
        float percentCFP = (float)firstPassCounter / (float)totalCounter * 100.0f;
        float percentCSP = (float)secondPassCounter / (float)totalCounter * 100.0f;
        float percentCSSP = (float)cssCounter / (float)totalCounter * 100.0f;
        float percentFP = (float)finalizeCounter / (float)totalCounter * 100.0f;
        float percentGP = (float)generatorCounter / (float)totalCounter * 100.0f;
        String strCFP = String.format(TIME_PATTERN, StringUtil.convertTime((long)firstPassCounter), (int)percentCFP);
        String strCSP = String.format(TIME_PATTERN, StringUtil.convertTime((long)secondPassCounter), (int)percentCSP);
        String strCSSP = String.format(TIME_PATTERN, StringUtil.convertTime((long)cssCounter), (int)percentCSSP);
        String strFP = String.format(TIME_PATTERN, StringUtil.convertTime((long)finalizeCounter), (int)percentFP);
        String strGP = String.format(TIME_PATTERN, StringUtil.convertTime((long)generatorCounter), (int)percentGP);
        buffer.append(String.format(reportPattern, label, strCFP, strCSP, strCSSP, strFP, strGP, StringUtil.convertTime((long)totalCounter)));
    }

    protected void printReportLine2(StringBuilder buffer, String reportPattern, String label, long firstPassCounter, long secondPassCounter, long cssCounter, long finalizeCounter, long generatorCounter, long totalCounter) {
        buffer.append(String.format(reportPattern, label, StringUtil.convertTime((long)firstPassCounter), StringUtil.convertTime((long)secondPassCounter), StringUtil.convertTime((long)cssCounter), StringUtil.convertTime((long)finalizeCounter), StringUtil.convertTime((long)generatorCounter), StringUtil.convertTime((long)totalCounter)));
    }

    protected CompilerEntry getEntry(JAXXCompiler compiler) {
        int key = compiler.getOutputClassName().hashCode();
        CompilerEntry result = (CompilerEntry)this.entries.get(key);
        if (result == null) {
            result = new CompilerEntry(compiler);
            this.entries.put(key, result);
            this.compilers.add(compiler);
        }
        return result;
    }

    protected JAXXCompiler getCompiler(int hasCode) {
        for (JAXXCompiler c : this.compilers) {
            if (hasCode != c.getOutputClassName().hashCode()) continue;
            return c;
        }
        return null;
    }

    protected class CompilerEntry {
        JAXXCompiler compiler;
        SortedMap<String, Long> times;

        public CompilerEntry(JAXXCompiler compiler) {
            this.compiler = compiler;
            this.times = new TreeMap<String, Long>();
        }
    }

    public static class ProfileResult {
        long min;
        long max;
        long average;
        long total;
        Map<JAXXCompiler, Long> delta;
        List<Long> times;

        ProfileResult(Map<JAXXCompiler, Long> delta) {
            this.delta = delta;
            this.times = new ArrayList<Long>(delta.values());
            Collections.sort(this.times);
            this.min = this.times.get(0);
            this.max = this.times.get(this.times.size() - 1);
            this.total = 0L;
            this.average = 0L;
            for (Long t : this.times) {
                this.total += t.longValue();
            }
            this.average = this.total / (long)this.times.size();
        }

        public long getTime(JAXXCompiler compiler) {
            for (Map.Entry<JAXXCompiler, Long> entry : this.delta.entrySet()) {
                if (!entry.getKey().equals(compiler)) continue;
                return entry.getValue();
            }
            throw new IllegalArgumentException("could not find time for compiler " + compiler);
        }

        public void clear() {
            this.times.clear();
            this.delta.clear();
        }

        public JAXXCompiler getCompiler(Long l) {
            for (Map.Entry<JAXXCompiler, Long> entry : this.delta.entrySet()) {
                if (!entry.getValue().equals(l)) continue;
                return entry.getKey();
            }
            throw new IllegalArgumentException("could not find compiler for time " + l);
        }
    }
}

