/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElement;
import jaxx.compiler.java.JavaFileGenerator;

public class JavaMethod
extends JavaElement
implements Comparable<JavaMethod> {
    private String returnType;
    private JavaArgument[] arguments;
    private String[] exceptions;
    private String body;
    private boolean override;

    JavaMethod(int modifiers, String returnType, String name, JavaArgument[] arguments, String[] exceptions, String bodyCode, boolean override) {
        super(modifiers, name);
        this.returnType = returnType;
        this.override = override;
        this.arguments = arguments;
        this.exceptions = exceptions;
        this.body = bodyCode == null ? "" : bodyCode;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public JavaArgument[] getArguments() {
        return this.arguments;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public boolean isOverride() {
        return this.override;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public int compareTo(JavaMethod o) {
        return JavaElementComparator.compare(this, o);
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public static EnumMap<MethodOrder, List<JavaMethod>> getSortedMethods(List<JavaMethod> methods) {
        int[] scopes;
        EnumMap<MethodOrder, List<JavaMethod>> result = new EnumMap<MethodOrder, List<JavaMethod>>(MethodOrder.class);
        for (MethodOrder methodOrder : MethodOrder.values()) {
            result.put(methodOrder, new ArrayList());
        }
        EnumSet<MethodOrder> allConstants = EnumSet.allOf(MethodOrder.class);
        ArrayList<JavaMethod> allMethods = new ArrayList<JavaMethod>(methods);
        for (int scope : scopes = new int[]{8, 1, 4, 2}) {
            EnumSet<MethodOrder> constants = JavaMethod.getMethodOrderScope(allConstants, scope);
            Iterator itMethods = allMethods.iterator();
            block2: while (itMethods.hasNext()) {
                JavaMethod method = (JavaMethod)itMethods.next();
                for (MethodOrder constant : constants) {
                    if (!constant.accept(method.getModifiers(), method)) continue;
                    result.get((Object)constant).add(method);
                    itMethods.remove();
                    continue block2;
                }
            }
            constants.clear();
        }
        if (!allMethods.isEmpty()) {
            throw new IllegalArgumentException("could not find a " + MethodOrder.class + " for method " + allMethods);
        }
        for (MethodOrder methodOrder : MethodOrder.values()) {
            Collections.sort(result.get((Object)methodOrder));
        }
        return result;
    }

    public static EnumSet<MethodOrder> getMethodOrderScope(EnumSet<MethodOrder> allConstants, int scope) {
        EnumSet<MethodOrder> constants = EnumSet.noneOf(MethodOrder.class);
        for (MethodOrder order : allConstants) {
            if (!order.accept(scope)) continue;
            constants.add(order);
        }
        return constants;
    }

    public static enum MethodOrder {
        statics(8, "Statics methods"),
        constructors(1, "Constructors"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.returnType == null;
            }
        }
        ,
        JAXXObject(1, "JAXXObject implementation"){
            private final List<String> methods = Arrays.asList("applyDataBinding", "firePropertyChange", "getObjectById", "get$objectMap", "processDataBinding", "removeDataBinding", "registerDataBinding", "getDataBindings");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.getName());
            }
        }
        ,
        JAXXContext(1, "JAXXContext implementation"){
            private final List<String> methods = Arrays.asList("getContextValue", "getDelegateContext", "getParentContainer", "removeContextValue", "setContextValue");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.getName());
            }
        }
        ,
        JAXXValidation(1, "JAXXValidator implementation"){
            private final List<String> methods = Arrays.asList("getValidator", "getValidatorIds", "registerValidatorFields");

            @Override
            public boolean accept(JavaMethod method) {
                boolean contains = this.methods.contains(method.getName());
                if (contains && method.getName().equals("getValidator")) {
                    return method.getArguments().length == 1;
                }
                return contains;
            }
        }
        ,
        events(1, "Event methods"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("do") && method.getName().contains("__");
            }
        }
        ,
        publicGetters(1, "Public acessor methods"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("get") || method.getName().startsWith("is");
            }
        }
        ,
        publicSetters(1, "Public mutator methods"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("set");
            }
        }
        ,
        otherPublic(1, "Other methods"){

            @Override
            public boolean accept(int mod) {
                return super.accept(mod) && !Modifier.isStatic(mod);
            }
        }
        ,
        protectedGetters(4, "Protected acessors methods"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("get") || method.getName().startsWith("is");
            }
        }
        ,
        createMethod(6, "Components creation methods"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("create") || method.getName().startsWith("add");
            }
        }
        ,
        internalMethod(2, "Internal jaxx methods"){
            private final List<String> methods = Arrays.asList("$completeSetup", "$registerDefaultBindings", "$initialize");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.getName());
            }
        }
        ,
        protecteds(4, "Other protected methods"){}
        ,
        packageLocal(0, "Package methods"){

            @Override
            public boolean accept(int mod) {
                return !Modifier.isStatic(mod) && !Modifier.isPublic(mod) && !Modifier.isProtected(mod);
            }
        }
        ,
        privates(2, "Other private methods");

        private final String header;
        private int modifier;

        private MethodOrder(int modifier, String header) {
            this.header = JavaFileGenerator.getHeader(header);
            this.modifier = modifier;
        }

        public String getHeader() {
            return this.header;
        }

        public boolean accept(JavaMethod method) {
            return true;
        }

        public boolean accept(int mod) {
            return (mod & this.modifier) != 0;
        }

        public boolean accept(int mod, JavaMethod method) {
            return this.accept(mod) && this.accept(method);
        }

        public static MethodOrder valueOf(JavaMethod method, int scope) {
            for (MethodOrder o : MethodOrder.values()) {
                if (!o.accept(scope, method)) continue;
                return o;
            }
            throw new IllegalArgumentException("could not find a " + MethodOrder.class + " for method " + method);
        }
    }
}

