/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaConstructor;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class JavaElementFactory {
    private static final Log log = LogFactory.getLog(JavaElementFactory.class);

    public static JavaFile newFile(int modifiers, String className) {
        JavaFile file = new JavaFile(modifiers, className);
        return file;
    }

    public static JavaArgument newArgument(String type, String name) {
        JavaArgument argument = JavaElementFactory.newArgument(type, name, false);
        return argument;
    }

    public static JavaArgument newArgument(String type, String name, boolean isFinal) {
        JavaArgument argument = new JavaArgument(type, name, isFinal);
        return argument;
    }

    public static JavaField newField(int modifiers, String returnType, String name, boolean override) {
        return JavaElementFactory.newField(modifiers, returnType, name, override, null, new String[0]);
    }

    public static JavaField newField(int modifiers, String returnType, String name, boolean override, String initializer, String ... initializerTypes) {
        return new JavaField(modifiers, returnType, name, override, initializer, initializerTypes);
    }

    public static JavaConstructor newConstructor(int modifiers, String name, String body, String[] exceptions, JavaArgument ... arguments) {
        return new JavaConstructor(modifiers, name, arguments, exceptions, body);
    }

    public static JavaConstructor newConstructor(int modifiers, String name, String body, JavaArgument ... arguments) {
        return JavaElementFactory.newConstructor(modifiers, name, body, StringUtil.EMPTY_STRING_ARRAY, arguments);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String body, boolean override, String[] exceptions, JavaArgument ... arguments) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + " returns : " + returnType));
        }
        return new JavaMethod(modifiers, returnType, name, arguments, exceptions, body, override);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String body, boolean override, JavaArgument ... arguments) {
        return JavaElementFactory.newMethod(modifiers, returnType, name, body, override, StringUtil.EMPTY_STRING_ARRAY, arguments);
    }

    public static JavaField cloneField(JavaField field) {
        return JavaElementFactory.newField(field.getModifiers(), field.getType(), field.getName(), field.isOverride(), field.getInitializer(), field.getInitializerTypes());
    }

    public static JavaMethod cloneMethod(JavaMethod method) {
        String[] incomingExceptions = method.getExceptions();
        String[] exceptions = new String[incomingExceptions.length];
        System.arraycopy(incomingExceptions, 0, exceptions, 0, exceptions.length);
        JavaArgument[] arguments = new JavaArgument[method.getArguments().length];
        for (int i = 0; i < arguments.length; ++i) {
            JavaArgument argument = arguments[i];
            arguments[i] = JavaElementFactory.cloneArgument(argument);
        }
        return JavaElementFactory.newMethod(method.getModifiers(), method.getReturnType(), method.getName(), method.getBody(), method.isOverride(), exceptions, arguments);
    }

    public static JavaArgument cloneArgument(JavaArgument argument) {
        JavaArgument result = JavaElementFactory.newArgument(argument.getType(), argument.getName(), argument.isFinal());
        return result;
    }
}

