/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.beans;

import jaxx.compiler.CompilerException;
import jaxx.compiler.beans.JAXXFeatureDescriptor;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;

public class JAXXPropertyDescriptor
extends JAXXFeatureDescriptor {
    private ClassDescriptor propertyType;
    private MethodDescriptor readMethod;
    private MethodDescriptor writeMethod;
    private boolean bound;

    public JAXXPropertyDescriptor(ClassDescriptor classDescriptor, String propertyName) {
        this(classDescriptor, propertyName, null, null);
    }

    public JAXXPropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, MethodDescriptor readMethod, MethodDescriptor writeMethod) {
        this(classDescriptor, propertyName, readMethod, writeMethod, false);
    }

    public JAXXPropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, MethodDescriptor readMethod, MethodDescriptor writeMethod, boolean bound) {
        super(classDescriptor, propertyName);
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.bound = bound;
    }

    public MethodDescriptor getReadMethodDescriptor() {
        if (this.readMethod == null) {
            try {
                this.readMethod = this.getClassDescriptor().getMethodDescriptor("get" + JAXXPropertyDescriptor.capitalize(this.getName()), new ClassDescriptor[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    this.readMethod = this.getClassDescriptor().getMethodDescriptor("is" + JAXXPropertyDescriptor.capitalize(this.getName()), new ClassDescriptor[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return this.readMethod;
    }

    public MethodDescriptor getWriteMethodDescriptor() {
        if (this.writeMethod == null) {
            try {
                String methodName = "set" + JAXXPropertyDescriptor.capitalize(this.getName());
                MethodDescriptor read = this.getReadMethodDescriptor();
                if (read == null) {
                    throw new CompilerException("Internal error: requesting 'set' method for property of unknown type: '" + this.getName() + "' (in " + this.getClassDescriptor() + ")");
                }
                this.writeMethod = this.getClassDescriptor().getMethodDescriptor(methodName, read.getReturnType());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this.writeMethod;
    }

    public ClassDescriptor getPropertyType() {
        if (this.propertyType == null) {
            MethodDescriptor read = this.getReadMethodDescriptor();
            if (read != null) {
                this.propertyType = read.getReturnType();
            } else {
                MethodDescriptor write = this.getWriteMethodDescriptor();
                this.propertyType = write.getParameterTypes()[0];
            }
        }
        return this.propertyType;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }
}

