package jaxx.compiler.binding;

import jaxx.compiler.java.JavaFileGenerator;
import jaxx.runtime.JAXXBinding;

/**
 * The contract of a writer of {@link jaxx.runtime.JAXXBinding} creation code from a {@link DataBinding}.
 * <p/>
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision:  $
 *          <p/>
 *          Mise a jour: $Date:  $ par :
 *          $Author: tchemit $
 */
public interface JAXXBindingWriter<B extends JAXXBinding> {

    /**
     * Test if a binding can be treated by the writer.
     *
     * @param binding the binding to test
     * @return {@code true} if this writer can be used to generate binding creation code, {@code false} otherwise.
     */
    boolean accept(DataBinding binding);

    /**
     * Test if the writer was at least used once (says that the method
     * {@link #write(DataBinding, JavaFileGenerator, StringBuilder)} was at least invoked once).
     *
     * @return {@code true} if this writer was used
     */
    boolean isUsed();

    /**
     * @return the type of {@link JAXXBinding} to generate
     */
    Class<B> getType();

    /**
     * Generate the creation code of the given {@code binding} and push it in the given {@code buffer}.
     * <p/>
     * Note: after beean in this method, the {@link #isUsed()} should always return {@code true}.
     *
     * @param binding   the binding to use
     * @param generator common generator to build creation code
     * @param buffer    where to push creation code
     */
    void write(DataBinding binding, JavaFileGenerator generator, StringBuilder buffer);
}
