/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.css;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DataSource;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.SimpleNode;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.tags.TagManager;
import jaxx.runtime.css.Rule;
import jaxx.runtime.css.Selector;
import jaxx.runtime.css.Stylesheet;

public class StylesheetHelper {
    public static void applyTo(CompiledObject object, JAXXCompiler compiler, Stylesheet stylesheet, Stylesheet overrides) throws CompilerException {
        Rule[] pseudoClasses;
        Map<String, String> overriddenProperties = overrides != null ? StylesheetHelper.getApplicableProperties(overrides, object) : null;
        Map properties = StylesheetHelper.getApplicableProperties(stylesheet, object);
        if (properties != null) {
            if (overriddenProperties != null) {
                properties.keySet().removeAll(overriddenProperties.keySet());
            }
            DefaultObjectHandler handler = TagManager.getTagHandler(object.getObjectClass());
            for (Map.Entry<String, String> e : properties.entrySet()) {
                String value = e.getValue();
                if (value.equals("<inline attribute>") || value.equals("<data binding>")) continue;
                handler.setAttribute(object, e.getKey(), e.getValue(), false, compiler);
            }
        }
        if ((pseudoClasses = StylesheetHelper.getApplicablePseudoClasses(stylesheet, object)) != null) {
            LinkedHashMap combinedPseudoClasses = new LinkedHashMap();
            for (Rule pseudoClass1 : pseudoClasses) {
                Selector[] selectors;
                for (Selector selector : selectors = pseudoClass1.getSelectors()) {
                    if (StylesheetHelper.appliesTo(selector, object) != 2) continue;
                    properties = pseudoClass1.getProperties();
                    String pseudoClass = selector.getPseudoClass();
                    HashMap combinedProperties = (HashMap)combinedPseudoClasses.get(pseudoClass);
                    if (combinedProperties == null) {
                        combinedProperties = new HashMap();
                        combinedPseudoClasses.put(pseudoClass, combinedProperties);
                    }
                    combinedProperties.putAll(properties);
                }
            }
            int count = 0;
            for (Map.Entry e : combinedPseudoClasses.entrySet()) {
                StylesheetHelper.applyPseudoClass((String)e.getKey(), (Map)e.getValue(), object, compiler, count++);
            }
        }
    }

    public static String replaceObjectReferences(String code, String id) throws CompilerException {
        JavaParser p = new JavaParser(new StringReader(code + ";"));
        p.Expression();
        SimpleNode node = p.popNode();
        StylesheetHelper.scanNode(node, id);
        return node.getText();
    }

    public static void scanNode(SimpleNode node, String id) {
        if (node.getId() == 37) {
            String name = node.getText();
            if (name.equals("object") || name.indexOf(".") != -1 && name.substring(0, name.indexOf(".")).trim().equals("object")) {
                node.firstToken.image = id;
            }
        } else {
            int count = node.jjtGetNumChildren();
            for (int i = 0; i < count; ++i) {
                StylesheetHelper.scanNode(node.getChild(i), id);
            }
        }
    }

    public static void compilePseudoClassAdd(String pseudoClass, CompiledObject object, String propertyCode, JAXXCompiler compiler) throws CompilerException {
        if (pseudoClass.startsWith("{")) {
            pseudoClass = pseudoClass.substring(1, pseudoClass.length() - 1).trim();
            pseudoClass = StylesheetHelper.replaceObjectReferences(pseudoClass, object.getJavaCode());
            String dest = object.getId() + ".style." + pseudoClass + ".add";
            String destCode = compiler.getJavaCode(dest);
            if (compiler.hasProcessDataBinding()) {
                compiler.appendProcessDataBinding("else ");
            }
            compiler.appendProcessDataBinding("if ($dest.equals(" + destCode + ")) { if (" + pseudoClass + ") { " + propertyCode + "} }");
            new DataSource(dest, pseudoClass, compiler).compile("new DataBindingListener(" + compiler.getRootObject().getJavaCode() + ", " + destCode + ")");
            compiler.appendInitDataBindings("applyDataBinding(" + destCode + ");");
            return;
        }
        MouseEventEnum constant = MouseEventEnum.valueOf(pseudoClass);
        String property = null;
        switch (constant) {
            case mousedown: {
                property = "mousePressed";
                break;
            }
            case mouseout: {
                property = "mouseExited";
                break;
            }
            case mouseover: {
                property = "mouseEntered";
                break;
            }
            case mouseup: {
                property = "mouseReleased";
            }
        }
        ClassDescriptor mouseListenerDescriptor = ClassDescriptorLoader.getClassDescriptor(MouseListener.class);
        ClassDescriptor mouseEventDescriptor = ClassDescriptorLoader.getClassDescriptor(MouseEvent.class);
        try {
            MethodDescriptor addMouseListener = object.getObjectClass().getMethodDescriptor("addMouseListener", mouseListenerDescriptor);
            MethodDescriptor methodDescriptor = mouseListenerDescriptor.getMethodDescriptor(property, mouseEventDescriptor);
            object.addEventHandler("style." + pseudoClass + ".add", addMouseListener, methodDescriptor, propertyCode, compiler);
        }
        catch (NoSuchMethodException e) {
            compiler.reportError("mouseover pseudoclass cannot be applied to object " + object.getObjectClass().getName() + " (no addMouseListener method)");
        }
    }

    public static void compilePseudoClassRemove(String pseudoClass, CompiledObject object, String propertyCode, JAXXCompiler compiler) throws CompilerException {
        if (pseudoClass.startsWith("{")) {
            pseudoClass = pseudoClass.substring(1, pseudoClass.length() - 1).trim();
            pseudoClass = StylesheetHelper.replaceObjectReferences(pseudoClass, object.getJavaCode());
            String dest = object.getId() + ".style." + pseudoClass + ".remove";
            String destCode = compiler.getJavaCode(dest);
            if (compiler.hasProcessDataBinding()) {
                compiler.appendProcessDataBinding("else ");
            }
            compiler.appendProcessDataBinding("if ($dest.equals(" + destCode + ")) { if (" + StylesheetHelper.invert(pseudoClass) + ") { " + propertyCode + "} }");
            new DataSource(dest, pseudoClass, compiler).compile("new DataBindingListener(" + compiler.getRootObject().getJavaCode() + ", " + destCode + ")");
            compiler.appendInitDataBindings("applyDataBinding(" + destCode + ");");
            return;
        }
        MouseEventEnum constant = MouseEventEnum.valueOf(pseudoClass);
        String property = null;
        switch (constant) {
            case mousedown: {
                property = "mousePressed";
                break;
            }
            case mouseout: {
                property = "mouseReleased";
                break;
            }
            case mouseover: {
                property = "mouseExited";
                break;
            }
            case mouseup: {
                property = "mousePressed";
            }
        }
        ClassDescriptor mouseListenerDescriptor = ClassDescriptorLoader.getClassDescriptor(MouseListener.class);
        ClassDescriptor mouseEventDescriptor = ClassDescriptorLoader.getClassDescriptor(MouseEvent.class);
        try {
            MethodDescriptor addMouseListener = object.getObjectClass().getMethodDescriptor("addMouseListener", mouseListenerDescriptor);
            MethodDescriptor methodDescriptor = mouseListenerDescriptor.getMethodDescriptor(property, mouseEventDescriptor);
            object.addEventHandler("style." + pseudoClass + ".remove", addMouseListener, methodDescriptor, propertyCode, compiler);
        }
        catch (NoSuchMethodException e) {
            compiler.reportError("mouseover pseudoclass cannot be applied to object " + object.getObjectClass().getName() + " (no addMouseListener method)");
        }
    }

    public static String invert(String javaCode) {
        return (javaCode = javaCode.trim()).startsWith("!") ? javaCode.substring(1) : "!(" + javaCode + ")";
    }

    public static String unwrap(ClassDescriptor type, String valueCode) {
        if (type == ClassDescriptorLoader.getClassDescriptor(Boolean.TYPE)) {
            return "((java.lang.Boolean) " + valueCode + ").booleanValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Byte.TYPE)) {
            return "((java.lang.Byte) " + valueCode + ").byteValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Short.TYPE)) {
            return "((java.lang.Short) " + valueCode + ").shortValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Integer.TYPE)) {
            return "((java.lang.Integer) " + valueCode + ").intValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Long.TYPE)) {
            return "((java.lang.Long) " + valueCode + ").longValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Float.TYPE)) {
            return "((java.lang.Float) " + valueCode + ").floatValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Double.TYPE)) {
            return "((java.lang.Double) " + valueCode + ").doubleValue()";
        }
        if (type == ClassDescriptorLoader.getClassDescriptor(Character.TYPE)) {
            return "((java.lang.Character) " + valueCode + ").charValue()";
        }
        return valueCode;
    }

    public static void applyPseudoClass(String pseudoClass, Map<String, String> properties, CompiledObject object, JAXXCompiler compiler, int priority) throws CompilerException {
        String unwrappedValue;
        Class<?> typeClass;
        DataBinding dataBinding1;
        String valueCode;
        String dataBinding;
        ClassDescriptor type;
        String property;
        if (pseudoClass.indexOf("[") != -1) {
            pseudoClass = pseudoClass.substring(0, pseudoClass.indexOf("["));
        }
        StringBuffer buffer = new StringBuffer();
        DefaultObjectHandler handler = TagManager.getTagHandler(object.getObjectClass());
        boolean valueDeclared = false;
        String eol = JAXXCompiler.getLineSeparator();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            property = e.getKey();
            type = handler.getPropertyType(object, property, compiler);
            dataBinding = compiler.processDataBindings(e.getValue());
            if (dataBinding != null) {
                valueCode = "new jaxx.runtime.css.DataBinding(" + compiler.getJavaCode(object.getId() + "." + property + "." + priority) + ")";
                dataBinding1 = new DataBinding(dataBinding, object.getId() + "." + property + "." + priority, handler.getSetPropertyCode(object.getJavaCode(), property, "(" + JAXXCompiler.getCanonicalName(type) + ") " + dataBinding, compiler));
                dataBinding1.compile(compiler, false);
            } else {
                try {
                    typeClass = type != null ? ClassDescriptorLoader.getClass(type.getName(), type.getClassLoader()) : null;
                    valueCode = compiler.getJavaCode(compiler.convertFromString(e.getValue(), typeClass));
                }
                catch (ClassNotFoundException ex) {
                    compiler.reportError("could not find class " + type.getName());
                    return;
                }
            }
            if (!valueDeclared) {
                buffer.append("java.lang.Object ");
                valueDeclared = true;
            }
            buffer.append("value = jaxx.runtime.css.Pseudoclasses.applyProperty(").append(compiler.getOutputClassName()).append(".this, ").append(object.getJavaCode()).append(", ").append(compiler.getJavaCode(property)).append(", ").append(valueCode).append(", jaxx.runtime.css.Pseudoclasses.wrap(").append(handler.getGetPropertyCode(object.getJavaCode(), property, compiler)).append("), ").append(priority).append(");").append(eol);
            buffer.append("if (!(value instanceof jaxx.runtime.css.DataBinding)) {").append(eol);
            unwrappedValue = StylesheetHelper.unwrap(type, "value");
            buffer.append("    ").append(handler.getSetPropertyCode(object.getJavaCode(), property, "(" + JAXXCompiler.getCanonicalName(type) + ") " + unwrappedValue, compiler)).append(eol);
            buffer.append("}").append(eol);
        }
        if (pseudoClass.equals("focused")) {
            pseudoClass = "{ object.hasFocus() }";
        } else if (pseudoClass.equals("unfocused")) {
            pseudoClass = "{ !object.hasFocus() }";
        } else if (pseudoClass.equals("enabled")) {
            pseudoClass = "{ object.isEnabled() }";
        } else if (pseudoClass.equals("disabled")) {
            pseudoClass = "{ !object.isEnabled() }";
        } else if (pseudoClass.equals("selected")) {
            pseudoClass = "{ object.isSelected() }";
        } else if (pseudoClass.equals("deselected")) {
            pseudoClass = "{ !object.isSelected() }";
        }
        StylesheetHelper.compilePseudoClassAdd(pseudoClass, object, buffer.toString(), compiler);
        buffer.setLength(0);
        valueDeclared = false;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            property = e.getKey();
            type = handler.getPropertyType(object, property, compiler);
            dataBinding = compiler.processDataBindings(e.getValue());
            if (dataBinding != null) {
                valueCode = "new jaxx.runtime.css.DataBinding(" + compiler.getJavaCode(object.getId() + "." + property + "." + priority) + ")";
                dataBinding1 = new DataBinding(dataBinding, object.getId() + "." + property + "." + priority, handler.getSetPropertyCode(object.getJavaCode(), property, "(" + JAXXCompiler.getCanonicalName(type) + ") " + dataBinding, compiler));
                dataBinding1.compile(compiler, false);
            } else {
                try {
                    typeClass = type != null ? ClassDescriptorLoader.getClass(type.getName(), type.getClassLoader()) : null;
                    valueCode = compiler.getJavaCode(compiler.convertFromString(e.getValue(), typeClass));
                }
                catch (ClassNotFoundException ex) {
                    compiler.reportError("could not find class " + type.getName());
                    return;
                }
            }
            if (!valueDeclared) {
                buffer.append("java.lang.Object ");
                valueDeclared = true;
            }
            buffer.append("value = jaxx.runtime.css.Pseudoclasses.removeProperty(").append(compiler.getOutputClassName()).append(".this, ").append(object.getJavaCode()).append(", ").append(compiler.getJavaCode(property)).append(", ").append(valueCode).append(", jaxx.runtime.css.Pseudoclasses.wrap(").append(handler.getGetPropertyCode(object.getJavaCode(), property, compiler)).append("), ").append(priority).append(");").append(eol);
            buffer.append("if (!(value instanceof jaxx.runtime.css.DataBinding)) {").append(eol);
            unwrappedValue = StylesheetHelper.unwrap(type, "value");
            buffer.append("    ").append(handler.getSetPropertyCode(object.getJavaCode(), property, "(" + JAXXCompiler.getCanonicalName(type) + ") " + unwrappedValue, compiler)).append(eol);
            buffer.append("}").append(eol);
        }
        StylesheetHelper.compilePseudoClassRemove(pseudoClass, object, buffer.toString(), compiler);
    }

    public static Map<String, String> getApplicableProperties(Stylesheet s, CompiledObject object) throws CompilerException {
        DefaultObjectHandler handler = TagManager.getTagHandler(object.getObjectClass());
        HashMap result = null;
        for (Rule rule : s.getRules()) {
            int apply = StylesheetHelper.appliesTo(rule, object);
            if (apply != 4 && apply != 3) continue;
            if (result == null) {
                result = new HashMap();
            }
            for (Map.Entry entry : rule.getProperties().entrySet()) {
                String property = (String)entry.getKey();
                if (apply != 4 && !handler.isPropertyInherited(property)) continue;
                result.put(property, entry.getValue());
            }
        }
        return result;
    }

    public static Rule[] getApplicablePseudoClasses(Stylesheet s, CompiledObject object) throws CompilerException {
        ArrayList<Rule> result = null;
        for (Rule rule : s.getRules()) {
            if (StylesheetHelper.appliesTo(rule, object) != 2) continue;
            if (result == null) {
                result = new ArrayList<Rule>();
            }
            result.add(rule);
        }
        return result != null ? result.toArray(new Rule[result.size()]) : null;
    }

    public static Rule inlineAttribute(CompiledObject object, String propertyName, boolean dataBinding) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(propertyName, dataBinding ? "<data binding>" : "<inline attribute>");
        return new Rule(new Selector[]{new Selector(null, null, null, object.getId(), true)}, properties);
    }

    public static int appliesTo(Rule rule, CompiledObject object) throws CompilerException {
        Selector selector;
        int appliesTo = 0;
        Selector[] arr$ = rule.getSelectors();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (appliesTo = Math.max(StylesheetHelper.appliesTo(selector = arr$[i$], object), appliesTo)) != 4 && appliesTo != 3; ++i$) {
        }
        return appliesTo;
    }

    public static int appliesTo(Selector selector, CompiledObject object) {
        boolean inheritOnly = false;
        String javaClassName = selector.getJavaClassName();
        String styleClass = selector.getStyleClass();
        String pseudoClass = selector.getPseudoClass();
        String id = selector.getId();
        for (CompiledObject parent = object; parent != null; parent = parent.getParent()) {
            boolean idMatch;
            boolean classMatch;
            boolean bl = classMatch = javaClassName == null;
            if (!classMatch) {
                ClassDescriptor javaClass = parent.getObjectClass();
                do {
                    String name;
                    if (!(name = javaClass.getName()).equals(javaClassName) && !name.substring(name.lastIndexOf(".") + 1).equals(javaClassName)) continue;
                    classMatch = true;
                    break;
                } while ((javaClass = javaClass.getSuperclass()) != null);
            }
            boolean styleClassMatch = styleClass == null || styleClass.equals(parent.getStyleClass());
            String objectId = parent.getId();
            objectId = objectId.substring(objectId.lastIndexOf(".") + 1);
            boolean bl2 = idMatch = id == null || (' ' + objectId + ' ').indexOf(' ' + id + ' ') > -1;
            if (classMatch && styleClassMatch && idMatch) {
                if (pseudoClass != null) {
                    return inheritOnly ? 1 : 2;
                }
                return inheritOnly ? 3 : 4;
            }
            inheritOnly = true;
        }
        return 0;
    }

    public static enum MouseEventEnum {
        mouseover,
        mouseout,
        mousedown,
        mouseup;

    }
}

