/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataBinding {
    protected static final Log log = LogFactory.getLog(DataBinding.class);
    private String id;
    private String source;
    private String assignment;

    public DataBinding(String source, String id, String assignment) {
        this.id = id;
        this.source = source;
        this.assignment = assignment;
        if (log.isDebugEnabled()) {
            log.debug((Object)("id=" + id + " assignement=" + assignment + " source=" + source));
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean compile(JAXXCompiler compiler, boolean quickNoDependencies) throws CompilerException {
        boolean needTest;
        DataSource dataSource = new DataSource(this.id, this.source, compiler);
        boolean result = dataSource.compile("new DataBindingListener(this, " + compiler.getJavaCode(this.id) + ")");
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.id + " isBinding ? " + result));
        }
        String eol = JAXXCompiler.getLineSeparator();
        if (!result && quickNoDependencies) {
            if (!this.id.endsWith(".layout")) {
                compiler.appendInitDataBindings(this.assignment + eol);
            }
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        if (compiler.hasProcessDataBinding()) {
            buffer.append(" else ");
        } else {
            buffer.append("    ");
        }
        buffer.append("if (").append(compiler.getJavaCode(this.id)).append(".equals($dest)) {").append(eol);
        String objectCode = dataSource.getObjectCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.id + " objectCode= " + objectCode));
        }
        boolean bl = needTest = objectCode != null && !compiler.getRootObject().getId().equals(objectCode);
        if (needTest) {
            buffer.append("        if (").append(objectCode).append(" != null) {").append(eol);
            buffer.append("    ");
        }
        buffer.append("        ").append(this.assignment.trim());
        if (needTest) {
            buffer.append(eol).append("        }");
        }
        buffer.append(eol).append("    }");
        compiler.appendProcessDataBinding(buffer.toString());
        return true;
    }
}

