/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.CompilerException;
import jaxx.compiler.DefaultCompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFinalizer;
import jaxx.compiler.JAXXProfile;
import jaxx.compiler.SymbolTable;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.spi.Initializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXXEngine {
    protected static final Log log = LogFactory.getLog(JAXXEngine.class);
    protected static JAXXEngine singleton;
    protected CompilerConfiguration configuration;
    protected final File[] files;
    protected final String[] classNames;
    private List<File> jaxxFiles = new ArrayList<File>();
    private List<String> jaxxFileClassNames = new ArrayList<String>();
    protected Map<String, JAXXCompiler> compilers = new HashMap<String, JAXXCompiler>();
    protected Map<File, SymbolTable> symbolTables = new HashMap<File, SymbolTable>();
    private LifeCycle currentPass;
    protected List<String> warnings = new ArrayList<String>();
    protected List<String> errors = new ArrayList<String>();
    protected JAXXProfile profiler;
    protected Map<String, CompiledObjectDecorator> decorators;
    protected List<JAXXCompilerFinalizer> finalizers;

    public void addJaxxFileClassName(String className) {
        this.jaxxFileClassNames.add(className);
    }

    public void addJaxxFile(File jaxxFile) {
        this.jaxxFiles.add(jaxxFile);
    }

    public boolean containsJaxxFileClassName(String className) {
        return this.jaxxFileClassNames.contains(className);
    }

    public LifeCycle getCurrentPass() {
        return this.currentPass;
    }

    public static synchronized JAXXEngine newLaunchor() {
        return JAXXEngine.newLaunchor((File[])null, null, null);
    }

    public static synchronized JAXXEngine newLaunchor(File base, String[] relativePaths, CompilerConfiguration configuration) {
        File[] files = new File[relativePaths.length];
        String[] classNames = new String[relativePaths.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(base, relativePaths[i]);
            classNames[i] = relativePaths[i].substring(0, relativePaths[i].lastIndexOf("."));
            classNames[i] = classNames[i].replace(File.separatorChar, '.');
            classNames[i] = classNames[i].replace('/', '.');
            classNames[i] = classNames[i].replace('\\', '.');
            classNames[i] = classNames[i].replace(':', '.');
        }
        return JAXXEngine.newLaunchor(files, classNames, configuration);
    }

    public static synchronized JAXXEngine newLaunchor(File[] files, String[] classNames, CompilerConfiguration configuration) {
        if (singleton != null) {
            singleton.reset();
        }
        singleton = new JAXXEngine(files, classNames, configuration);
        return singleton;
    }

    public static JAXXEngine get() throws NullPointerException {
        if (singleton == null) {
            throw new NullPointerException("no launchor was registred via newLaunchor method");
        }
        return singleton;
    }

    public static boolean isRegistred() {
        return singleton != null;
    }

    public static void loadLibraries(boolean verbose) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (verbose) {
            log.info((Object)("with cl " + classloader));
        }
        ServiceLoader<Initializer> loader = ServiceLoader.load(Initializer.class, classloader);
        for (Initializer initializer : loader) {
            if (verbose) {
                log.info((Object)("load initializer " + initializer));
            }
            initializer.initialize();
        }
    }

    protected JAXXEngine(File[] files, String[] classNames, CompilerConfiguration options) {
        this.configuration = options == null ? new DefaultCompilerConfiguration() : options;
        this.files = files;
        this.classNames = classNames;
        if (log.isDebugEnabled()) {
            log.debug((Object)("files : " + Arrays.toString(files)));
        }
        if (this.configuration.isProfile()) {
            this.profiler = new JAXXProfile();
        }
    }

    protected void reset() {
        this.jaxxFiles.clear();
        this.jaxxFileClassNames.clear();
        this.symbolTables.clear();
        this.compilers.clear();
        if (this.profiler != null) {
            this.profiler.clear();
            this.profiler = null;
        }
        if (this.decorators != null) {
            this.decorators.clear();
            this.decorators = null;
        }
        if (this.finalizers != null) {
            this.finalizers.clear();
            this.finalizers = null;
        }
    }

    public String getVersion() {
        return "2.0.0";
    }

    public static JAXXCompiler createDummyCompiler(ClassLoader classLoader) {
        JAXXCompiler compiler = new JAXXCompiler(null, null, null, null, null, null);
        compiler.classLoader = classLoader;
        return compiler;
    }

    public JAXXCompiler getJAXXCompiler(String className) {
        return this.compilers == null ? null : this.compilers.get(className);
    }

    public SymbolTable getSymbolTable(String className) {
        JAXXCompiler compiler = this.getJAXXCompiler(className);
        if (compiler == null) {
            return null;
        }
        return compiler.getSymbolTable();
    }

    public CompiledObjectDecorator getDecorator(String name) throws IllegalArgumentException {
        CompiledObjectDecorator decorator = this.decorators.get(name);
        if (decorator == null) {
            throw new IllegalArgumentException("could not find decorator with key " + name + " (known decorators : " + this.decorators.keySet() + ")");
        }
        return decorator;
    }

    public CompiledObjectDecorator getDecorator(Class<?> type) {
        for (CompiledObjectDecorator decorator : this.decorators.values()) {
            if (type != decorator.getClass()) continue;
            return decorator;
        }
        return null;
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int run() {
        try {
            boolean success = true;
            for (LifeCycle state : LifeCycle.values()) {
                if (!success) break;
                this.currentPass = state;
                if (this.configuration.isVerbose()) {
                    log.info((Object)("'" + (Object)((Object)state) + "' on " + this.jaxxFiles.size() + " file(s)"));
                }
                success = state.run(this);
            }
            int n = success ? this.compilers.size() : -1;
            return n;
        }
        catch (CompilerException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            int n = -1;
            return n;
        }
        catch (Throwable e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            if (this.configuration.isResetAfterCompile() && this.errors.isEmpty()) {
                this.reset();
            }
        }
    }

    protected JAXXCompiler getCompiler(String className, String message) throws CompilerException {
        JAXXCompiler compiler = this.compilers.get(className);
        if (compiler == null) {
            throw new CompilerException(message);
        }
        return compiler;
    }

    protected JAXXCompiler newCompiler(File parentFile, File file, String className) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        Constructor<? extends JAXXCompiler> cons = this.configuration.getCompilerClass().getConstructor(JAXXEngine.class, File.class, File.class, String.class, CompilerConfiguration.class, List.class);
        return cons.newInstance(this, parentFile, file, className, this.configuration, Arrays.asList("java.awt.*", "java.awt.event.*", "java.beans.*", "java.io.*", "java.lang.*", "java.util.*", "javax.swing.*", "javax.swing.border.*", "javax.swing.event.*", "jaxx.runtime.swing.JAXXButtonGroup", "jaxx.runtime.swing.HBox", "jaxx.runtime.swing.VBox", "jaxx.runtime.swing.Table", "jaxx.runtime.Util", "jaxx.runtime.SwingUtil", "static org.nuiton.i18n.I18n._", "static jaxx.runtime.Util.createImageIcon"));
    }

    public void addProfileTime(JAXXCompiler compiler, String key) {
        if (this.profiler != null) {
            this.profiler.addTime(compiler, key);
        }
    }

    protected static enum LifeCycle {
        init{

            @Override
            public boolean run(JAXXEngine engine) {
                boolean success = true;
                engine.warnings.clear();
                engine.errors.clear();
                if (engine.decorators == null) {
                    engine.decorators = new TreeMap<String, CompiledObjectDecorator>();
                    for (CompiledObjectDecorator decorator : ServiceLoader.load(CompiledObjectDecorator.class)) {
                        engine.decorators.put(decorator.getName(), decorator);
                    }
                }
                engine.finalizers = new ArrayList<JAXXCompilerFinalizer>();
                for (JAXXCompilerFinalizer finalizer : ServiceLoader.load(JAXXCompilerFinalizer.class)) {
                    engine.finalizers.add(finalizer);
                }
                engine.jaxxFiles.addAll(Arrays.asList(engine.files));
                engine.jaxxFileClassNames.addAll(Arrays.asList(engine.classNames));
                return success;
            }
        }
        ,
        compile_first_pass{

            @Override
            public boolean run(JAXXEngine engine) throws Exception {
                boolean compiled;
                boolean success = true;
                do {
                    compiled = false;
                    assert (engine.jaxxFiles.size() == engine.jaxxFileClassNames.size());
                    Iterator filesIterator = new ArrayList(engine.jaxxFiles).iterator();
                    Iterator classNamesIterator = new ArrayList(engine.jaxxFileClassNames).iterator();
                    while (filesIterator.hasNext()) {
                        File file = (File)filesIterator.next();
                        String className = (String)classNamesIterator.next();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("compile first pass for " + className));
                        }
                        if (engine.symbolTables.get(file) != null) continue;
                        compiled = true;
                        if (engine.compilers.containsKey(className)) {
                            throw new CompilerException("Internal error: " + className + " is already being compiled, attempting to compile it again");
                        }
                        File destDir = engine.configuration.getTargetDirectory();
                        if (destDir != null) {
                            int dotPos = className.lastIndexOf(".");
                            if (dotPos != -1) {
                                destDir = new File(destDir, className.substring(0, dotPos).replace('.', File.separatorChar));
                            }
                            if (!destDir.exists() && !destDir.mkdirs()) {
                                log.warn((Object)("could not create directory " + destDir));
                                continue;
                            }
                        }
                        JAXXCompiler compiler = engine.newCompiler(file.getParentFile(), file, className);
                        this.addStartProfileTime(engine, compiler);
                        engine.compilers.put(className, compiler);
                        compiler.compileFirstPass();
                        this.addEndProfileTime(engine, compiler);
                        assert (!engine.symbolTables.values().contains(compiler.getSymbolTable())) : "symbolTable is already registered";
                        engine.symbolTables.put(file, compiler.getSymbolTable());
                        if (!compiler.isFailed()) continue;
                        success = false;
                    }
                } while (compiled);
                return success;
            }
        }
        ,
        compile_second_pass{

            @Override
            public boolean run(JAXXEngine engine) throws Exception {
                boolean success = true;
                ArrayList jaxxFilesClone = new ArrayList(engine.jaxxFiles);
                for (String className : engine.jaxxFileClassNames) {
                    JAXXCompiler compiler = engine.getCompiler(className, "Internal error: could not find compiler for " + className + " during second pass");
                    this.addStartProfileTime(engine, compiler);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("runInitializers for " + className));
                    }
                    if (!compiler.isFailed()) {
                        compiler.runInitializers();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("compile second pass for " + className));
                    }
                    compiler.compileSecondPass();
                    this.addEndProfileTime(engine, compiler);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("done with result [" + !compiler.isFailed() + "] for " + className));
                    }
                    if (!compiler.isFailed()) continue;
                    success = false;
                }
                if (!((Object)jaxxFilesClone).equals(engine.jaxxFiles)) {
                    throw new AssertionError((Object)("Internal error: compilation set altered during pass 2 (was " + jaxxFilesClone + ", modified to " + engine.jaxxFiles + ")"));
                }
                return success;
            }
        }
        ,
        stylesheet_pass{

            @Override
            public boolean run(JAXXEngine engine) throws Exception {
                boolean success = true;
                for (String className : engine.jaxxFileClassNames) {
                    JAXXCompiler compiler = engine.getCompiler(className, "Internal error: could not find compiler for " + className + " during stylesheet application");
                    this.addStartProfileTime(engine, compiler);
                    compiler.applyStylesheets();
                    this.addEndProfileTime(engine, compiler);
                    if (!compiler.isFailed()) continue;
                    success = false;
                }
                return success;
            }
        }
        ,
        finalize_compiler{

            @Override
            public boolean run(JAXXEngine engine) throws Exception {
                boolean success = true;
                for (String className : engine.jaxxFileClassNames) {
                    JAXXCompiler compiler = engine.getCompiler(className, "Internal error: could not find compiler for " + className + " during code generation");
                    this.addStartProfileTime(engine, compiler);
                    compiler.finalizeCompiler(engine.finalizers);
                    this.addEndProfileTime(engine, compiler);
                    if (!compiler.isFailed()) continue;
                    success = false;
                }
                return success;
            }
        }
        ,
        generate_pass{

            @Override
            public boolean run(JAXXEngine engine) throws Exception {
                boolean success = true;
                JavaFileGenerator generator = new JavaFileGenerator(JAXXCompiler.getLineSeparator(), engine.configuration.isVerbose());
                for (String className : engine.jaxxFileClassNames) {
                    JAXXCompiler compiler = engine.getCompiler(className, "Internal error: could not find compiler for " + className + " during code generation");
                    this.addStartProfileTime(engine, compiler);
                    compiler.generate(generator);
                    this.addEndProfileTime(engine, compiler);
                    if (!compiler.isFailed()) continue;
                    success = false;
                }
                return success;
            }
        }
        ,
        profile_pass{

            @Override
            public boolean run(JAXXEngine engine) throws Exception {
                boolean success = true;
                if (engine.configuration.isProfile()) {
                    StringBuilder buffer = engine.profiler.computeProfileReport();
                    log.info((Object)buffer.toString());
                }
                return success;
            }
        };


        public abstract boolean run(JAXXEngine var1) throws Exception;

        void addStartProfileTime(JAXXEngine engine, JAXXCompiler compiler) {
            engine.addProfileTime(compiler, this.name() + "_start");
        }

        void addEndProfileTime(JAXXEngine engine, JAXXCompiler compiler) {
            engine.addProfileTime(compiler, this.name() + "_end");
        }
    }
}

