/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.List;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.Generator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaField;
import jaxx.compiler.JavaFile;
import jaxx.compiler.JavaMethod;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.tags.validator.BeanValidatorHandler;
import jaxx.types.TypeManager;

public class ValidatorGenerator
implements Generator {
    protected static final JavaField VALIDATOR_IDS_FIELD = JavaField.newField(4, "java.util.List<String>", "validatorIds", "new ArrayList<String>()");

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        if (!BeanValidatorHandler.hasValidator(compiler)) {
            return;
        }
        for (CompiledObject object : compiler.getObjects().values()) {
            List<CompiledObject.ChildRef> childs = object.getChilds();
            if (childs == null || childs.isEmpty()) continue;
            for (CompiledObject.ChildRef child : childs) {
                String javaCode = child.getChildJavaCode();
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (!found) continue;
                child.setChildJavaCode(SwingUtil.class.getName() + ".boxComponentWithJxLayer(" + javaCode + ")");
            }
        }
        for (BeanValidatorHandler.CompiledBeanValidator validator : BeanValidatorHandler.getValidators(compiler)) {
            String id = TypeManager.getJavaCode(validator.getId());
            compiler.appendLateInitializer("validatorIds.add(" + id + ");");
            compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
            compiler.appendLateInitializer("getValidator(" + id + ").installUIs();");
            compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
            compiler.appendLateInitializer("getValidator(" + id + ").reloadBean();");
            compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
        }
        compiler.appendLateInitializer("validatorIds = java.util.Collections.unmodifiableList(validatorIds);");
        compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        if (!BeanValidatorHandler.hasValidator(compiler)) {
            return;
        }
        Class<?> validatorClass = compiler.getOptions().getValidatorClass();
        String validatorFQN = validatorClass.getName();
        javaFile.addImport(validatorFQN);
        Class<JAXXValidator> validatorInterface = JAXXValidator.class;
        if (javaFile.isSuperclassIsJAXXObject()) {
            ClassDescriptor superClass = ClassDescriptorLoader.getClassDescriptor(javaFile.getSuperClass());
            boolean parentIsValidator = ClassDescriptorLoader.getClassDescriptor(validatorInterface).isAssignableFrom(superClass);
            if (parentIsValidator) {
                return;
            }
        }
        javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));
        javaFile.addField(VALIDATOR_IDS_FIELD);
        javaFile.addMethod(JavaMethod.newMethod(1, validatorFQN + "<?>", "getValidator", "return (" + validatorFQN + ") (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);", new JavaArgument("String", "validatorId")));
    }
}

