/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;
import org.w3c.dom.Element;

import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.WindowConstants;

public class JInternalFrameHandler extends DefaultComponentHandler {

    public JInternalFrameHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, JInternalFrame.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledObject(id, getBeanClass(), compiler) {
            @Override
            public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
                if (ClassDescriptorLoader.getClassDescriptor(JMenuBar.class).isAssignableFrom(child.getObjectClass())) {
                    appendAdditionCode(getId() + ".setJMenuBar(" + child.getId() + ");");
                } else {
                    super.addChild(child, constraints, compiler);
                }
            }
        };
    }

    @Override
    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        setAttribute(object, "visible", "true", false, compiler);
        setAttribute(object, "closable", "true", false, compiler);
        setAttribute(object, "defaultCloseOperation", String.valueOf(WindowConstants.DISPOSE_ON_CLOSE), false, compiler);
    }


    @Override
    public void setAttributes(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        super.setAttributes(object, tag, compiler);
        compiler.appendInitializerCode(object.getId() + ".pack();\n");
    }
}