/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nFilter;
import org.nuiton.i18n.I18nLanguage;
import org.nuiton.i18n.I18nStore;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;

public class I18n {
    private static final Log log = LogFactory.getLog(I18n.class);
    @Deprecated
    public static final String ISO_8859_1_ENCONDING = "ISO-8859-1";
    @Deprecated
    public static final String UTF_8_ENCONDING = "UTF-8";
    @Deprecated
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    @Deprecated
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    @Deprecated
    protected static I18nInitializer initializer;
    protected static I18nStore store;
    protected static I18nFilter filter;
    private static final Object[] EMPTY_OBJECT_ARRAY;

    @Deprecated
    public static void setInitializer(I18nInitializer initializer) {
        I18n.initializer = initializer;
    }

    public static void setFilter(I18nFilter filter) {
        I18n.filter = filter;
    }

    public static void init(I18nInitializer initializer, Locale locale) {
        if (initializer == null) {
            initializer = I18n.getDefaultInitializer();
        }
        if (locale == null) {
            locale = I18nUtil.newLocale(null, null);
        }
        I18n.initStore(initializer, locale);
    }

    @Deprecated
    public static void init() {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Using deprecated init method.");
        }
        I18n.init(null, (Locale)null);
    }

    @Deprecated
    public static void init(String language, String country) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Using deprecated init method.");
        }
        I18n.init(null, I18nUtil.newLocale(language, country));
    }

    @Deprecated
    public static void init(Locale locale) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Using deprecated init method.");
        }
        I18n.init(null, locale);
    }

    public static void reload() {
        I18n.checkInit();
        I18nInitializer initializer = store.getResolver();
        Locale locale = store.getCurrentLocale();
        I18n.close();
        I18n.init(initializer, locale);
    }

    public static void setDefaultLocale(Locale locale) {
        I18n.checkInit();
        store.setCurrentLocale(locale);
    }

    public static Locale getDefaultLocale() {
        I18n.checkInit();
        Locale locale = store.getCurrentLocale();
        return locale;
    }

    public static String l_(Locale locale, String message, Object ... args) {
        I18n.checkInit();
        if (message == null) {
            return null;
        }
        I18nLanguage language = I18n.getLanguage(locale);
        String result = language.translate(message);
        if (args.length == 0) {
            return I18n.applyFilter(result);
        }
        try {
            return I18n.applyFilter(String.format(result, args));
        }
        catch (Exception eee) {
            try {
                return I18n.applyFilter(String.format(message, args));
            }
            catch (Exception zzz) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)I18n._("nuitonutil.error.i18n.untranslated.message", message), (Throwable)zzz);
                }
                return I18n.applyFilter(message);
            }
        }
    }

    @Deprecated
    public static String _(String message) {
        return I18n._(message, EMPTY_OBJECT_ARRAY);
    }

    public static String _(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        Locale locale = I18n.getDefaultLocale();
        String result = I18n.l_(locale, message, args);
        return result;
    }

    public static String n_(String message, Object ... args) {
        if (args.length == 0) {
            return message;
        }
        try {
            return String.format(message, args);
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n._("nuitonutil.error.i18n.unformated.message", message, Arrays.toString(args)), (Throwable)eee);
            }
            return message;
        }
    }

    @Deprecated
    public static String n_(String message) {
        return I18n.n_(message, EMPTY_OBJECT_ARRAY);
    }

    public static void close() {
        if (store != null) {
            store.close();
            store = null;
        }
    }

    @Deprecated
    public static I18nInitializer getInitializer() {
        return initializer;
    }

    public static I18nStore getStore() {
        return store;
    }

    protected static String applyFilter(String message) {
        if (I18n.getFilter() != null) {
            return I18n.getFilter().applyFilter(message);
        }
        return message;
    }

    protected static I18nLanguage getCurrentLanguage() {
        I18nLanguage language = I18n.getLanguage(null);
        return language;
    }

    protected static I18nLanguage getLanguage(Locale locale) {
        I18n.checkInit();
        if (locale == null && (locale = I18n.getDefaultLocale()) == null) {
            locale = store.getDefaultLocale();
        }
        I18nLanguage language = store.getLanguage(locale);
        return language;
    }

    protected static I18nFilter getFilter() {
        return filter;
    }

    protected static void initStore(I18nInitializer initializer, Locale locale) throws NullPointerException {
        if (initializer == null) {
            throw new NullPointerException("initializer parameter can not be null");
        }
        if (locale == null) {
            throw new NullPointerException("locale parameter can not be null");
        }
        if (store != null) {
            store.close();
            store = null;
        }
        store = new I18nStore(locale, initializer);
        I18n.setDefaultLocale(locale);
    }

    protected static I18nInitializer getDefaultInitializer() {
        I18nInitializer initializer = I18n.initializer != null ? I18n.initializer : new ClassPathI18nInitializer();
        return initializer;
    }

    protected static void checkInit() {
        if (store == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"\n\nI18n was not initialized! will init it with default initializer and default locale, it might not translate anything fro you...\nPlease use the method I18n.init(I18nInitializer, Locale) before any calling to a translation...\n\n");
            }
            I18n.init(null, (Locale)null);
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

