/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: AbstractI18nBundleMojo.java 1782 2010-10-25 07:57:22Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.1/maven-i18n-plugin/src/main/java/org/nuiton/i18n/plugin/bundle/AbstractI18nBundleMojo.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin.bundle;

import org.nuiton.i18n.plugin.AbstractI18nMojo;
import org.nuiton.plugin.PluginHelper;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

/**
 * Created: 26 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public abstract class AbstractI18nBundleMojo extends AbstractI18nMojo {

    /**
     * Repertoire ou generer les bundles.
     *
     * @parameter expression="${i18n.collectOutputDir}" default-value="${basedir}/target/i18n"
     * @required
     * @since 1.0.2
     */
    protected File collectOutputDir;

    /**
     * Nom de base des fichiers qui contient les localisations des bundles.
     *
     * @parameter expression="${i18n.collectOutputName}"
     * default-value="collect-${project.artifactId}-i18n"
     * @required
     * @since 1.0.2
     */
    protected String collectOutputName;

    /**
     * Pour obtenir les urls des fichiers i18n d'un projet (avec recherche dans
     * ses dépendances).
     * <p/>
     * <b>Note:</b> L'ordre des urls reflète l'ordre des dépendances.
     *
     * @param locale la locale a traiter
     * @return les urls des bundles i18n detectees pour le projet.
     * @throws Exception pour tout problème
     */
    protected abstract URL[] getCollectI18nResources(Locale locale)
            throws Exception;

    /**
     * Pour obtenir le fichier contenant les localisation des bundles i18n du
     * projet pour une {@code locale} donnée.
     *
     * @param locale la locale
     * @param create un drapeau pour forcer la création du fichier s'il n'existe
     *               pas
     * @return le fichier qui contient les urls des bundles i18n pour la locale
     *         donnée.
     * @throws IOException pour tout pb
     */
    protected File getCollectOutputFile(Locale locale, boolean create)
            throws IOException {
        File bundleOut = getI18nFile(collectOutputDir, collectOutputName,
                                     locale, create);
        return bundleOut;
    }

    /**
     * @param src the source file to read
     * @return the url instanciated from lines of the source file.
     * @throws IOException if any pb while reading file
     * @deprecated since 1.2.2, use the {@link PluginHelper#getLinesAsURL(File)}
     *             instead.
     */
    @Deprecated
    public static URL[] getLinesAsURL(File src) throws IOException {
        return PluginHelper.getLinesAsURL(src);
    }

}
