/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import com.opensymphony.xwork2.util.DomHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.impl.AbstractParserXmlMojo;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="parserValidation", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParserValidationMojo
extends AbstractParserXmlMojo {
    public static final String DEFAULT_INCLUDES = "**/*-validation.xml";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/resources", required=true)
    protected File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*-validation.xml", required=true)
    protected String defaultIncludes;
    @Parameter(property="i18n.coreRuleFile", defaultValue="validation.rules", required=true)
    protected String coreRuleFile;
    @Parameter(property="i18n.useLocalResolver", defaultValue="true")
    protected boolean useLocalResolver;
    @Parameter(property="i18n.outputGetter", defaultValue="validation.getter", required=true)
    protected String outputGetter;
    private Map<String, String> dtdMappings = new HashMap<String, String>();

    public ParserValidationMojo() {
        this.dtdMappings.put("-//Apache Struts//XWork Validator 1.0//EN", "xwork-validator-1.0.dtd");
        this.dtdMappings.put("-//Apache Struts//XWork Validator 1.0.2//EN", "xwork-validator-1.0.2.dtd");
        this.dtdMappings.put("-//Apache Struts//XWork Validator 1.0.3//EN", "xwork-validator-1.0.3.dtd");
    }

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.cp){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file);
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    protected String getCoreRuleFile() {
        return this.coreRuleFile;
    }

    @Override
    protected AbstractParserXmlMojo.XmlFileParser newXmlFileParser(XPath xpath, DocumentBuilder builder) {
        return new AbstractParserXmlMojo.XmlFileParser(this.getLog(), this.encoding, this.oldParser, this.acceptPattern, this.showTouchedFiles, this.rules, xpath, builder, this.namespaces, this.isVerbose()){

            @Override
            protected Document fileToDocument(File fileToProcess) throws SAXException, IOException {
                InputSource in = new InputSource(FileUtils.openInputStream((File)fileToProcess));
                Document doc = DomHelper.parse((InputSource)in, (Map)ParserValidationMojo.this.dtdMappings);
                return doc;
            }

            @Override
            public String extract(String i18nString) {
                int end;
                String s = null;
                if (!i18nString.trim().isEmpty() && (end = (s = i18nString.trim()).indexOf("##")) > 0) {
                    s = s.substring(0, end);
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(i18nString + " = " + s));
                }
                return s;
            }
        };
    }
}

