/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.plugin;

import java.util.Collection;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAvailableDataMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        Collection<AvailableData> safeDataTypes = this.getAllAvailableDatas();
        for (AvailableData data : safeDataTypes) {
            buffer.append("\n");
            this.appendData(data, buffer);
        }
        buffer.append("\n");
        String info = safeDataTypes.size() == 1 ? buffer.toString() : "Get datas for data types : " + safeDataTypes + buffer.toString();
        this.getLog().info((CharSequence)info);
    }

    protected void appendData(AvailableData data, StringBuilder buffer) {
        Map<String, ?> map = data.getData();
        int size = map.size();
        String dataType = data.name();
        if (size == 0) {
            buffer.append("\nNo available ").append(dataType).append(".");
        } else if (size == 1) {
            buffer.append("\nFound one ").append(dataType).append(" : ");
        } else {
            buffer.append("\nFound ");
            buffer.append(size);
            buffer.append(" ");
            buffer.append(dataType);
            buffer.append("s : ");
        }
        for (Map.Entry<String, ?> e : map.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            buffer.append("\n [");
            buffer.append(name);
            buffer.append("] with implementation '");
            buffer.append(data.toString(value));
            buffer.append('\'');
        }
    }

    protected abstract Collection<AvailableData> getAllAvailableDatas();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface AvailableData {
        public String name();

        public Map<String, ?> getData();

        public String toString(Object var1);
    }
}

