/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.nuiton.plugin.AbstractPlugin;

public class ExecuteRemoteCommandMojo
extends AbstractPlugin {
    protected boolean verbose;
    protected MavenProject project;
    protected Proxy proxy;
    protected Settings settings;
    protected String repositoryId;
    protected String repositoryUrl;
    protected String command;
    protected WagonManager wagonManager;
    private CommandExecutor commandExecutor;

    protected void init() throws Exception {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        if (StringUtils.isEmpty((String)this.repositoryId)) {
            throw new MojoExecutionException("No 'repositoryId' defined.");
        }
        Server server = this.settings.getServer(this.repositoryId.trim());
        if (server == null) {
            throw new MojoExecutionException("Could not find server with id '" + this.repositoryId + "', check your settings.xml file.");
        }
        Repository repository = new Repository(this.repositoryId, this.repositoryUrl);
        Wagon wagon = this.getWagon(repository);
        if (!(wagon instanceof CommandExecutor)) {
            this.disconnect(wagon);
            throw new MojoExecutionException("The wagon " + wagon + " is not a command executor, " + "will not be able to execute command.");
        }
        this.commandExecutor = (CommandExecutor)wagon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will execute command : " + this.command));
        }
        try {
            this.commandExecutor.executeCommand(this.command);
        }
        finally {
            this.disconnect((Wagon)this.commandExecutor);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected Wagon getWagon(Repository repository) throws Exception {
        Wagon wagon = this.wagonManager.getWagon(repository);
        wagon.setTimeout(1000);
        if (this.getLog().isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        AuthenticationInfo auth = this.wagonManager.getAuthenticationInfo(repository.getId());
        ProxyInfo proxyInfo = this.getProxyInfo();
        if (proxyInfo != null) {
            wagon.connect(repository, auth, proxyInfo);
        } else {
            wagon.connect(repository, auth);
        }
        return wagon;
    }

    protected void disconnect(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (ConnectionException e) {
            Log log = this.getLog();
            if (log.isDebugEnabled()) {
                log.error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
            log.error((CharSequence)"Error disconnecting wagon - ignored");
        }
    }

    protected ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = null;
        if (this.proxy != null && !StringUtils.isEmpty((String)this.proxy.getHost())) {
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(this.proxy.getHost());
            proxyInfo.setType(this.proxy.getProtocol());
            proxyInfo.setPort(this.proxy.getPort());
            proxyInfo.setNonProxyHosts(this.proxy.getNonProxyHosts());
            proxyInfo.setUserName(this.proxy.getUsername());
            proxyInfo.setPassword(this.proxy.getPassword());
        }
        return proxyInfo;
    }
}

