package org.nuiton.eugene.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-eugene-plugin.<br/> Call <pre>  mvn eugene:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Dec 20 18:06:44 CET 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nuiton.eugene:maven-eugene-plugin:2.0.0-beta-2", 0 );
        append( sb, "", 0 );

        append( sb, "EUGene :: Maven plugin", 0 );
        append( sb, "maven plugin to use the eugene library", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 8 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "available-data".equals( goal ) )
        {
            append( sb, "eugene:available-data", 0 );
            append( sb, "Obtain the list of some known data informations.\nUse the dataTypes property to specify a specific data type to use (otherwise will display all known data types).\n\nUser: chemit Date: 24 nov. 2009 Time: 00:22:37\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataTypes", 2 );
                append( sb, "Data type to display (let empty to see all datas). Can specify more than one separated by comma.\nAvailable types are :\n\nmodeltype,\nmodelreader,\nmodeltemplate,\nwriter\n\nNote: Let empty to display all data types.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "copyVersionFiles".equals( goal ) )
        {
            append( sb, "eugene:copyVersionFiles", 0 );
            append( sb, "Copy a file set to a versionned directory structure.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "copyVersionDir", 2 );
                append( sb, "Le dossier de destination des fichiers copi\u00e9s. Doit contenir un nom de modele : %MODELNAME%", 3 );
                append( sb, "", 0 );

                append( sb, "copyVersionFiles", 2 );
                append( sb, "Les mappings a sauvegarder", 3 );
                append( sb, "", 0 );

                append( sb, "copyVersionResources", 2 );
                append( sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers objectmodel a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou generer les classes java.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<copyVersionResources>\n\n<input>target/generated-sources/models</input>\n\n<output>target/generated-sources/java</output>\n\n</copyVersionResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<copyVersionResources>\n\n<input>target/generated-sources/test-models</input>\n\n<output>target/generated-sources/test-java</output>\n\n</copyVersionResources>\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to be used for generation of files.", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: *.*model)", 2 );
                append( sb, "Fichiers objectModel a lire pour determiner la version.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate".equals( goal ) )
        {
            append( sb, "eugene:generate", 0 );
            append( sb, "Deprecated. since 2.0.0, use now the SmartGenerateMojo.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Effectue toutes les g\u00e9n\u00e9rations et copie les fichiers g\u00e9n\u00e9r\u00e9s dans le r\u00e9pertoire de compilation", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "defaultPackage (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom par d\u00e9faut du paquetage g\u00e9n\u00e9r\u00e9.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to be used for generation of files.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTemplates", 2 );
                append( sb, "Templates \u00e0 ne pas utiliser.", 3 );
                append( sb, "", 0 );

                append( sb, "extraClassPathDirectory", 2 );
                append( sb, "An extra directory to be added to the classpath.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedPackages", 2 );
                append( sb, "List of packages to generate (comma separated).\nIf the parameter is not filled, will generate all packages.\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateResources", 2 );
                append( sb, "Les entr\u00e9es sorties du plugin.\n\n\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers objectmodel a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou generer les classes java.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<generateResources>\n\n\u00a0\u00a0<input>target/generated-sources/models</input>\n\n\u00a0\u00a0<output>target/generated-sources/java</output>\n\n</generateResources>\n\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n\n<generateResources>\n\n\u00a0\u00a0<input>target/generated-sources/test-models</input>\n\n\u00a0\u00a0<output>target/generated-sources/test-java</output>\n\n</generateResources>\n", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: *.*model)", 2 );
                append( sb, "Fichier \u00e0 inclure.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "reader", 2 );
                append( sb, "Reader for transform input files in a Model to generate", 3 );
                append( sb, "", 0 );

                append( sb, "templates", 2 );
                append( sb, "Templates \u00e0 utiliser, s\u00e9par\u00e9s par des virgules.", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "eugene:help", 0 );
            append( sb, "Display help information on maven-eugene-plugin.\nCall\n\u00a0\u00a0mvn\u00a0eugene:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "smart-generate".equals( goal ) )
        {
            append( sb, "eugene:smart-generate", 0 );
            append( sb, "Smart file generator.\nFill inputs and mojo will chained needed writer.\n\nUser: chemit Date: 24 nov. 2009 Time: 00:22:37\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "defaultPackage (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom par d\u00e9faut du paquetage g\u00e9n\u00e9r\u00e9 (model input sepcific).", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "Ne g\u00e9n\u00e8re rien, analyse juste la configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to be used for generation of files.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTemplates", 2 );
                append( sb, "Templates \u00e0 ne pas utiliser lors de la transformations des models (model input sepcific).", 3 );
                append( sb, "", 0 );

                append( sb, "fullPackagePath (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom du paquetage pour les fichiers g\u00e9n\u00e9r\u00e9s (xmi input sepcific).", 3 );
                append( sb, "", 0 );

                append( sb, "generatedPackages", 2 );
                append( sb, "List of packages to generate (comma separated). (model input sepcific).\nIf the parameter is not filled, will generate all packages.\n", 3 );
                append( sb, "", 0 );

                append( sb, "inputs", 2 );
                append( sb, "Inputs files to used to generate the required model files.\n\nAn include has the following pattern :\n\u00a0writer:\nwhen you want to use a specific writer with his default io values.\nCan also write :\n\n\u00a0[writer:]directory:includes\nwhere includes is the pattern to find files from the directory given and must be terminated by the extension of files.\nSpecifying the writer can be usefull when you want to use a writer for an unknown extension by any writer.\n\nExample :\n\n<inputs>\n\u00a0\u00a0\u00a0\u00a0<input>zargo:</input>\n\u00a0\u00a0\u00a0\u00a0<input>src/main/xmi2:**\\/*.zargo</input>\n\u00a0\u00a0\u00a0\u00a0<input>zargo:src/main/xmi:**\\/*.zargo2</input>\n</inputs>\nNote: If your using a single input, you can just write :\n<inputs>zargo</inputs>\u00a0\u00a0\n", 3 );
                append( sb, "", 0 );

                append( sb, "modelType (Default: objectmodel)", 2 );
                append( sb, "The type of model to be used.\nBy default, use an objectmodel.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/generated-sources)", 2 );
                append( sb, "Where to generate files.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "properties", 2 );
                append( sb, "Properties to pass to writer.", 3 );
                append( sb, "", 0 );

                append( sb, "resolver (Default: org.nuiton.util.ResourceResolver)", 2 );
                append( sb, "Nom du resolver a utiliser pour les transformations xmi vers model (xmi input sepcific).", 3 );
                append( sb, "", 0 );

                append( sb, "skipInputs", 2 );
                append( sb, "List of input (protocol) not to treate separated by comma.\nExample :\n\n<skipInputs>xmi</skipInputs>\n<skipInputs>xmi,model</skipInputs>\n", 3 );
                append( sb, "", 0 );

                append( sb, "templates", 2 );
                append( sb, "Templates \u00e0 utiliser, s\u00e9par\u00e9s par des virgules pour les transformations depuis les models (model input sepcific).", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xmi2objectmodel".equals( goal ) )
        {
            append( sb, "eugene:xmi2objectmodel", 0 );
            append( sb, "Converti les fichiers XMI en fichier ObjectModel", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "acceptedXmiTypes (Default: xmi,uml)", 2 );
                append( sb, "Liste des types de modeles accept\u00e9s s\u00e9par\u00e9s par des vigules.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to be used for generation of files.", 3 );
                append( sb, "", 0 );

                append( sb, "extraClassPathDirectory", 2 );
                append( sb, "An extra directory to be added to the classpath.", 3 );
                append( sb, "", 0 );

                append( sb, "extractedPackages (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom du paquetage \u00e0 g\u00e9n\u00e9r\u00e9", 3 );
                append( sb, "", 0 );

                append( sb, "fullPackagePath (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom du paquetage pour les fichiers g\u00e9n\u00e9r\u00e9s", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "resolver (Default: org.nuiton.util.ResourceResolver)", 2 );
                append( sb, "Nom du resolver a utiliser", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );

                append( sb, "xmiResources", 2 );
                append( sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers xmi a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou extraire les xmi et copier les resources.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/models<\\output>\n\n</xmiResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/test-models<\\output>\n\n</xmiResources>\n\n\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xmi2statemodel".equals( goal ) )
        {
            append( sb, "eugene:xmi2statemodel", 0 );
            append( sb, "Converti les fichiers XMI en fichier StateModel", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "acceptedXmiTypes (Default: xmi,uml)", 2 );
                append( sb, "Liste des types de modeles accept\u00e9s s\u00e9par\u00e9s par des vigules.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to be used for generation of files.", 3 );
                append( sb, "", 0 );

                append( sb, "extraClassPathDirectory", 2 );
                append( sb, "An extra directory to be added to the classpath.", 3 );
                append( sb, "", 0 );

                append( sb, "extractedPackages (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom du paquetage \u00e0 g\u00e9n\u00e9r\u00e9", 3 );
                append( sb, "", 0 );

                append( sb, "fullPackagePath (Default: ${project.groupId}.${project.artifactId})", 2 );
                append( sb, "Nom du paquetage pour les fichiers g\u00e9n\u00e9r\u00e9s", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "resolver (Default: org.nuiton.util.ResourceResolver)", 2 );
                append( sb, "Nom du resolver a utiliser", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );

                append( sb, "xmiResources", 2 );
                append( sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers xmi a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou extraire les xmi et copier les resources.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/models<\\output>\n\n</xmiResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/test-models<\\output>\n\n</xmiResources>\n\n\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "zargo2xmi".equals( goal ) )
        {
            append( sb, "eugene:zargo2xmi", 0 );
            append( sb, "Extract zipped XMI files from zargo archive.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to be used for generation of files.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );

                append( sb, "zargoResources", 2 );
                append( sb, "Les entr\u00e9es-sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers zargo a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou extraire les xmi et copier les resources.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<zargoResources>\n\n\u00a0\u00a0<input>src/main/xmi</input>\n\n\u00a0\u00a0<output>target/generated-sources/xmi</ouput>\n\n</zargoResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<zargoResources>\n\n\u00a0\u00a0<input>src/test/xmi</input>\n\n\u00a0\u00a0<output>target/generated-sources/test-xmi</ouput>\n\n<zargoResources>\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
