/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton.eugene:maven-eugene-plugin:1.0.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "EUGene - plugin maven", 0);
        this.append(sb, "maven plugin to use the eugene library", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "copyVersionFiles".equals(this.goal)) {
            this.append(sb, "eugene:copyVersionFiles", 0);
            this.append(sb, "Copy a file set to a versionned directory structure.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "copyVersionDir", 2);
                this.append(sb, "Le dossier de destination des fichiers copi\u00e9s. Doit contenir un nom de modele : %MODELNAME%", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyVersionFiles", 2);
                this.append(sb, "Les mappings a sauvegarder", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyVersionResources", 2);
                this.append(sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers objectmodel a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou generer les classes java.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<copyVersionResources>\n\n<input>target/generated-sources/models</input>\n\n<output>target/generated-sources/java</output>\n\n</copyVersionResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<copyVersionResources>\n\n<input>target/generated-sources/test-models</input>\n\n<output>target/generated-sources/test-java</output>\n\n</copyVersionResources>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding to be used for generation of files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: *.*model)", 2);
                this.append(sb, "Fichiers objectModel a lire pour determiner la version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPhase (Default: false)", 2);
                this.append(sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "eugene:generate", 0);
            this.append(sb, "Effectue toutes les g\u00e9n\u00e9rations et copie les fichiers g\u00e9n\u00e9r\u00e9s dans le r\u00e9pertoire de compilation", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "defaultPackage (Default: ${project.groupId}.${project.artifactId})", 2);
                this.append(sb, "Nom par d\u00e9faut du paquetage g\u00e9n\u00e9r\u00e9.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding to be used for generation of files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeTemplates", 2);
                this.append(sb, "Templates \u00e0 ne pas utiliser.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraClassPathDirectory", 2);
                this.append(sb, "An extra directory to be added to the classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedPackages", 2);
                this.append(sb, "List of packages to generate (comma separated). If the parameter is not filled, will generate all packages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateResources", 2);
                this.append(sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers objectmodel a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou generer les classes java.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<generateResources>\n\n\u00a0\u00a0<input>target/generated-sources/models</input>\n\n\u00a0\u00a0<output>target/generated-sources/java</output>\n\n</generateResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<generateResources>\n\n\u00a0\u00a0<input>target/generated-sources/test-models</input>\n\n\u00a0\u00a0<output>target/generated-sources/test-java</output>\n\n</generateResources>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: *.*model)", 2);
                this.append(sb, "Fichier \u00e0 inclure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templates", 2);
                this.append(sb, "Templates \u00e0 utiliser, s\u00e9par\u00e9s par des virgules.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPhase (Default: false)", 2);
                this.append(sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "eugene:help", 0);
            this.append(sb, "Display help information on maven-eugene-plugin.\nCall\n\u00a0\u00a0mvn\u00a0eugene:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xmi2objectmodel".equals(this.goal)) {
            this.append(sb, "eugene:xmi2objectmodel", 0);
            this.append(sb, "Converti les fichiers XMI en fichier ObjectModel", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "acceptedXmiTypes (Default: xmi,uml)", 2);
                this.append(sb, "Liste des types de modeles accept\u00e9s s\u00e9par\u00e9s par des vigules.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding to be used for generation of files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraClassPathDirectory", 2);
                this.append(sb, "An extra directory to be added to the classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extractedPackages (Default: ${project.groupId}.${project.artifactId})", 2);
                this.append(sb, "Nom du paquetage \u00e0 g\u00e9n\u00e9r\u00e9", 3);
                this.append(sb, "", 0);
                this.append(sb, "fullPackagePath (Default: ${project.groupId}.${project.artifactId})", 2);
                this.append(sb, "Nom du paquetage pour les fichiers g\u00e9n\u00e9r\u00e9s", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolver (Default: org.nuiton.util.ResourceResolver)", 2);
                this.append(sb, "Nom du resolver a utiliser", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPhase (Default: false)", 2);
                this.append(sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmiResources", 2);
                this.append(sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers xmi a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou extraire les xmi et copier les resources.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/models<\\output>\n\n</xmiResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/test-models<\\output>\n\n</xmiResources>\n\n\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xmi2statemodel".equals(this.goal)) {
            this.append(sb, "eugene:xmi2statemodel", 0);
            this.append(sb, "Converti les fichiers XMI en fichier StateModel", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "acceptedXmiTypes (Default: xmi,uml)", 2);
                this.append(sb, "Liste des types de modeles accept\u00e9s s\u00e9par\u00e9s par des vigules.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding to be used for generation of files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraClassPathDirectory", 2);
                this.append(sb, "An extra directory to be added to the classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extractedPackages (Default: ${project.groupId}.${project.artifactId})", 2);
                this.append(sb, "Nom du paquetage \u00e0 g\u00e9n\u00e9r\u00e9", 3);
                this.append(sb, "", 0);
                this.append(sb, "fullPackagePath (Default: ${project.groupId}.${project.artifactId})", 2);
                this.append(sb, "Nom du paquetage pour les fichiers g\u00e9n\u00e9r\u00e9s", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolver (Default: org.nuiton.util.ResourceResolver)", 2);
                this.append(sb, "Nom du resolver a utiliser", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPhase (Default: false)", 2);
                this.append(sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmiResources", 2);
                this.append(sb, "Les entr\u00e9es sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers xmi a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou extraire les xmi et copier les resources.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/models<\\output>\n\n</xmiResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<xmiResources>\n\n\u00a0\u00a0<input>target/generated-sources/xmi<\\input>\n\n\u00a0\u00a0<output>target/generated-sources/test-models<\\output>\n\n</xmiResources>\n\n\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "zargo2xmi".equals(this.goal)) {
            this.append(sb, "eugene:zargo2xmi", 0);
            this.append(sb, "Extract zipped XMI files from zargo archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding to be used for generation of files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Ecrase les fichiers g\u00e9n\u00e9r\u00e9s.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPhase (Default: false)", 2);
                this.append(sb, "A flag to mark the mojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
                this.append(sb, "zargoResources", 2);
                this.append(sb, "Les entr\u00e9es-sorties du plugin.\nEn entr\u00e9e on demande des r\u00e9pertoires o\u00f9 chercher les fichiers zargo a convertir.\n\nEn sortie on demande le r\u00e9pertoire ou extraire les xmi et copier les resources.\n\nPar d\u00e9faut on a les valeurs suivantes :\n\n\n\n<zargoResources>\n\n\u00a0\u00a0<input>src/main/xmi</input>\n\n\u00a0\u00a0<output>target/generated-sources/xmi</ouput>\n\n</zargoResources>\n\n\nNote: si testPhase est activ\u00e9e, les valeurs par d\u00e9faut sont :\n\n\n<zargoResources>\n\n\u00a0\u00a0<input>src/test/xmi</input>\n\n\u00a0\u00a0<output>target/generated-sources/test-xmi</ouput>\n\n<zargoResources>\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

