/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.Generator;
import org.nuiton.eugene.plugin.EugeneAbstractMojo;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

public class EugenePlugin
extends EugeneAbstractMojo {
    protected PluginIOContext generateResources;
    protected String templates;
    protected String[] excludeTemplates;
    protected String includes;
    protected String defaultPackage;
    protected File extraClassPathDirectory;
    protected String generatedPackages;

    public void doAction() throws MojoExecutionException, MojoFailureException {
        List<String> packages;
        this.getLog().info((CharSequence)"Generating java sources from models");
        this.getLog().info((CharSequence)(" includes             : " + this.includes));
        this.getLog().info((CharSequence)(" using template       : " + this.templates));
        this.getLog().info((CharSequence)(" using defaultPackage : " + this.defaultPackage));
        File[] modelFiles = this.getModelFiles();
        if (modelFiles.length == 0) {
            this.getLog().warn((CharSequence)"no model to treate");
            return;
        }
        if (this.verbose) {
            for (File m : modelFiles) {
                this.getLog().info((CharSequence)("will treate model file : " + m));
            }
        }
        if ((packages = this.getPackagesToGenerate()) == null) {
            this.getLog().info((CharSequence)" generating all packages");
        } else {
            this.getLog().info((CharSequence)(" generating only for packages " + packages));
        }
        List<Generator> generators = this.getGenerators(packages);
        for (Generator generator : generators) {
            this.getLog().info((CharSequence)("Apply " + generator.getClass().getSimpleName() + " generator"));
            generator.generate(modelFiles, this.generateResources.getOutput());
        }
        this.fixCompileSourceRoots();
    }

    @Override
    protected PluginIOContext getResources() {
        return this.generateResources;
    }

    @Override
    protected PluginIOContext initResources() {
        File defaultIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "models"});
        File defaultOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "java"});
        File defaultTestIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-models"});
        File defaultTestOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-java"});
        this.generateResources = this.initResources(defaultIn, defaultOut, defaultTestIn, defaultTestOut);
        return this.generateResources;
    }

    protected List<String> getPackagesToGenerate() {
        ArrayList<String> generatedPackagesAsList = null;
        if (this.generatedPackages != null && !this.generatedPackages.isEmpty()) {
            generatedPackagesAsList = new ArrayList<String>();
            for (String s : this.generatedPackages.split(",")) {
                generatedPackagesAsList.add(s);
            }
        }
        return generatedPackagesAsList;
    }

    protected File[] getModelFiles() {
        ArrayList modelFiles = new ArrayList();
        Object[] includePatterns = this.includes.split(",");
        for (File srcDirGen : this.generateResources.getInputs()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Search for " + Arrays.toString(includePatterns) + " in " + srcDirGen.getAbsolutePath()));
            }
            List currentFiles = PluginHelper.getIncludedFiles((File)srcDirGen, (String[])includePatterns, null);
            modelFiles.addAll(currentFiles);
        }
        return modelFiles.toArray(new File[modelFiles.size()]);
    }

    protected List<Generator> getGenerators(List<String> generatedPackagesAsList) throws MojoFailureException, MojoExecutionException {
        Properties generatorProperties = new Properties();
        generatorProperties.setProperty("defaultPackage", this.defaultPackage);
        ArrayList<Generator> generators = new ArrayList<Generator>();
        String[] templatesNames = this.templates.split(",");
        ClassLoader fixedClassLoader = this.fixClassLoader();
        for (String templateName : templatesNames) {
            templateName = templateName.trim();
            try {
                Generator generator = (Generator)Class.forName(templateName, true, fixedClassLoader).newInstance();
                generator.setExcludeTemplates(Arrays.asList(this.excludeTemplates));
                generator.setProperties(generatorProperties);
                generator.setOverwrite(this.overwrite);
                generator.setEncoding(this.encoding);
                generator.setGeneratedPackages(generatedPackagesAsList);
                generators.add(generator);
            }
            catch (InstantiationException e) {
                throw new MojoFailureException("Can't instantiate generator : " + templateName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoFailureException("Can't access generator : " + templateName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MojoFailureException("Can't found generator : " + templateName, (Throwable)e);
            }
        }
        return generators;
    }

    protected void fixCompileSourceRoots() {
        if (this.project == null) {
            return;
        }
        File destDirGen = this.generateResources.getOutput();
        if (this.testPhase) {
            if (!this.project.getTestCompileSourceRoots().contains(destDirGen.getPath())) {
                this.getLog().info((CharSequence)("Add test compile source root : " + destDirGen));
                this.project.addTestCompileSourceRoot(destDirGen.getPath());
                Resource resources = new Resource();
                resources.setDirectory(destDirGen.getAbsolutePath());
                resources.setExcludes(Arrays.asList("**/*.java"));
                this.getLog().info((CharSequence)("Add test resource root :" + resources));
                this.project.addTestResource(resources);
            }
        } else if (!this.project.getCompileSourceRoots().contains(destDirGen.getPath())) {
            this.getLog().info((CharSequence)("Add compile source root : " + destDirGen));
            this.project.addCompileSourceRoot(destDirGen.getPath());
            Resource resources = new Resource();
            resources.setDirectory(destDirGen.getAbsolutePath());
            resources.setExcludes(Arrays.asList("**/*.java"));
            this.getLog().info((CharSequence)("Add resource root :" + resources));
            this.project.addResource(resources);
        }
    }

    protected ClassLoader fixClassLoader() throws MojoExecutionException {
        ArrayList urls = new ArrayList();
        HashSet urlsAsString = new HashSet();
        try {
            ClassLoader loader = null;
            if (this.extraClassPathDirectory != null) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Add extra directory in generator's classLoader : " + this.extraClassPathDirectory));
                }
                this.addDirectoryToUrlsList(this.extraClassPathDirectory, urls, urlsAsString);
            }
            if (this.project.getProjectReferences() != null) {
                Iterator i$ = this.project.getProjectReferences().entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    MavenProject relatedProject = (MavenProject)entry.getValue();
                    if (this.verbose) {
                        this.getLog().info((CharSequence)("Add project reference in generator's classLoader : '" + relatedProject.getArtifact() + "'"));
                    }
                    this.addDirectoryToUrlsList(relatedProject.getArtifact().getFile(), urls, urlsAsString);
                }
            }
            if (!this.project.getArtifacts().isEmpty()) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"Use resolved artifacts to build class-path");
                }
                for (Map.Entry o : this.project.getArtifacts()) {
                    Artifact a = (Artifact)o;
                    if (a.getScope().equals("provided")) continue;
                    this.addDirectoryToUrlsList(a.getFile(), urls, urlsAsString);
                }
            }
            loader = ((Object)((Object)this)).getClass().getClassLoader();
            if (!urls.isEmpty()) {
                loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
            }
            ClassLoader classLoader = loader;
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            urls.clear();
            urlsAsString.clear();
        }
    }
}

