package org.nuiton.eugene.test2.beangen;

import java.beans.PropertyChangeListener;
 import java.beans.PropertyChangeSupport;
 
public abstract class Roue {

    protected final PropertyChangeSupport pcs;
    public Voiture voiture;
    /**
     * Roue :
     */
    public Roue() {
        pcs = new PropertyChangeSupport(this);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * getVoiture :
     * @return Voiture 
     */
    public Voiture getVoiture() {
        return this.voiture;
    }

    /**
     * setVoiture :
     * @param newValue 
     */
    public void setVoiture(Voiture newValue) {
        Voiture oldValue = getVoiture();
        this.voiture = newValue;
        firePropertyChange("voiture", oldValue, newValue);
    }

    /**
     * mount :
     */
    public abstract void mount();

    /**
     * getModel :
     * @param id 
     * @return int 
     */
    public abstract int getModel(String id);


} //Roue
