package org.nuiton.eugene.test2.beangen;

import java.beans.PropertyChangeListener;
 import java.beans.PropertyChangeSupport;
 import java.io.Serializable;
 import java.util.Date;
 
public class RelationDTO implements Serializable {

    protected final PropertyChangeSupport pcs;
    public int idCompany;
    public int idDepartement;
    public Date dateDebut;
    public PersonneDTO person;
    /**
     * RelationDTO :
     */
    public RelationDTO() {
        pcs = new PropertyChangeSupport(this);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * getIdCompany :
     * @return int 
     */
    public int getIdCompany() {
        return this.idCompany;
    }

    /**
     * setIdCompany :
     * @param newValue 
     */
    public void setIdCompany(int newValue) {
        int oldValue = getIdCompany();
        this.idCompany = newValue;
        firePropertyChange("idCompany", oldValue, newValue);
    }

    /**
     * getIdDepartement :
     * @return int 
     */
    public int getIdDepartement() {
        return this.idDepartement;
    }

    /**
     * setIdDepartement :
     * @param newValue 
     */
    public void setIdDepartement(int newValue) {
        int oldValue = getIdDepartement();
        this.idDepartement = newValue;
        firePropertyChange("idDepartement", oldValue, newValue);
    }

    /**
     * getDateDebut :
     * @return Date 
     */
    public Date getDateDebut() {
        return this.dateDebut;
    }

    /**
     * setDateDebut :
     * @param newValue 
     */
    public void setDateDebut(Date newValue) {
        Date oldValue = getDateDebut();
        this.dateDebut = newValue;
        firePropertyChange("dateDebut", oldValue, newValue);
    }

    /**
     * getPerson :
     * @return PersonneDTO 
     */
    public PersonneDTO getPerson() {
        return this.person;
    }

    /**
     * setPerson :
     * @param newValue 
     */
    public void setPerson(PersonneDTO newValue) {
        PersonneDTO oldValue = getPerson();
        this.person = newValue;
        firePropertyChange("person", oldValue, newValue);
    }


} //RelationDTO
