package org.nuiton.eugene.test.beangen;
 
 import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Siege {

    public int noSerie;
    public Voiture voiture;
    protected final PropertyChangeSupport pcs;

    /**
     * Default constructor of Siege.
     */
    public Siege() {
        pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    public int getNoSerie() {
        return noSerie;
    }

    public Voiture getVoiture() {
        return voiture;
    }

    public void setNoSerie(int newValue) {
        int oldValue = getNoSerie();
        this.noSerie = newValue;
        firePropertyChange("noSerie", oldValue, newValue);
    }

    public void setVoiture(Voiture newValue) {
        Voiture oldValue = getVoiture();
        this.voiture = newValue;
        firePropertyChange("voiture", oldValue, newValue);
    }


    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
         append("noSerie", this.noSerie).
         append("voiture", this.voiture).
         toString();
        return result;
    }
 
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
      pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

} //Siege
