/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.util.json;

import org.neo4j.shell.ShellException;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class JSONParser {
    public static Object parse(String json) throws ShellException {
        try {
            String input = json.trim();
            if (input.isEmpty()) {
                return null;
            }
            if (input.charAt(0) == '{') {
                return new JSONObject(input).toMap();
            }
            if (input.charAt(0) == '[') {
                return new JSONArray(input).toList();
            }
            Object value = JSONObject.stringToValue(input);
            if (value.equals(null)) {
                return null;
            }
            return value;
        }
        catch (JSONException e) {
            throw new ShellException("Could not parse value " + json + " " + e.getMessage());
        }
    }
}

