/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.shell.ShellSettings;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ShellBootstrap
implements Serializable {
    private final boolean enable;
    private String host;
    private final int port;
    private final String name;
    private final boolean read_only;

    ShellBootstrap(Config config) {
        this.enable = (Boolean)config.get(ShellSettings.remote_shell_enabled);
        this.host = (String)config.get(ShellSettings.remote_shell_host);
        this.port = (Integer)config.get(ShellSettings.remote_shell_port);
        this.name = (String)config.get(ShellSettings.remote_shell_name);
        this.read_only = (Boolean)config.get(ShellSettings.remote_shell_read_only);
    }

    public ShellBootstrap(int port, String name) {
        this.enable = true;
        this.port = port;
        this.name = name;
        this.read_only = false;
    }

    public String serialize() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Broken implementation!", e);
        }
        return new BASE64Encoder().encode(os.toByteArray());
    }

    static String serializeStub(Remote obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(RemoteObject.toStub(obj));
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Broken implementation!", e);
        }
        return new BASE64Encoder().encode(os.toByteArray());
    }

    static ShellBootstrap deserialize(String data) {
        try {
            return (ShellBootstrap)new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(data))).readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    GraphDatabaseShellServer load(GraphDatabaseAPI graphDb) throws RemoteException {
        if (!this.enable) {
            return null;
        }
        return this.enable(new GraphDatabaseShellServer(graphDb, this.read_only));
    }

    void visit(GraphDatabaseShellServer state) {
    }

    public GraphDatabaseShellServer enable(GraphDatabaseShellServer server) throws RemoteException {
        server.makeRemotelyAvailable(this.host, this.port, this.name);
        return server;
    }
}

