/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.ReadOnlyGraphDatabaseApp;

public class Start
extends ReadOnlyGraphDatabaseApp {
    @Override
    public String getDescription() {
        return "Executes a Cypher query. Usage: start <rest of query>;\nExample: START me = node({self}) MATCH me-[:KNOWS]->you RETURN you.name;\nwhere {self} will be replaced with the current location in the graph.Please, note that the query must end with a semicolon.";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String query = parser.getLine();
        if (this.isComplete(query)) {
            String queryWithoutSemicolon = query.substring(0, query.lastIndexOf(";"));
            ExecutionEngine engine = new ExecutionEngine((GraphDatabaseService)this.getServer().getDb());
            try {
                ExecutionResult result = engine.execute(queryWithoutSemicolon, this.getParameters(session));
                out.println((Serializable)((Object)result.toString()));
            }
            catch (CypherException e) {
                throw ShellException.wrapCause(e);
            }
            return Continuation.INPUT_COMPLETE;
        }
        return Continuation.INPUT_INCOMPLETE;
    }

    private Map<String, Object> getParameters(Session session) throws ShellException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            NodeOrRelationship self = this.getCurrent(session);
            params.put("self", self.isNode() ? self.asNode() : self.asRelationship());
        }
        catch (ShellException shellException) {
            // empty catch block
        }
        return params;
    }

    private boolean isComplete(String query) {
        return query.trim().endsWith(";");
    }
}

