/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;

public class Rm
extends GraphDatabaseApp {
    @Override
    public String getDescription() {
        return "Removes a property from the current node or relationship.\nUsage: rm <key>";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        if (parser.arguments().isEmpty()) {
            throw new ShellException("Must supply the property key to remove, like: rm title");
        }
        String key = parser.arguments().get(0);
        NodeOrRelationship thing = this.getCurrent(session);
        if (thing.removeProperty(key) == null) {
            out.println((Serializable)((Object)("Property '" + key + "' not found")));
        }
        return Continuation.INPUT_COMPLETE;
    }
}

