/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.util.SingleNodePath;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.ReadOnlyGraphDatabaseApp;
import org.neo4j.shell.kernel.apps.Set;

public class Ls
extends ReadOnlyGraphDatabaseApp {
    private static final int DEFAULT_MAX_RELS_PER_TYPE_LIMIT = 10;

    public Ls() {
        this.addOptionDefinition("b", new OptionDefinition(OptionValueType.NONE, "Brief summary instead of full content"));
        this.addOptionDefinition("v", new OptionDefinition(OptionValueType.NONE, "Verbose mode"));
        this.addOptionDefinition("q", new OptionDefinition(OptionValueType.NONE, "Quiet mode"));
        this.addOptionDefinition("p", new OptionDefinition(OptionValueType.NONE, "Lists properties"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.NONE, "Lists relationships"));
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.MUST, "Filters property keys/values and relationship types. Supplied either as a single value or as a JSON string where both keys and values can contain regex. Starting/ending {} brackets are optional. Examples:\n  \"username\"\n\tproperty/relationship 'username' gets listed\n  \".*name:ma.*, age:''\"\n\tproperties with keys matching '.*name' and values matching 'ma.*' gets listed,\n\tas well as the 'age' property. Also relationships matching '.*name' or 'age'\n\tgets listed\n  \"KNOWS:out,LOVES:in\"\n\toutgoing KNOWS and incoming LOVES relationships gets listed"));
        this.addOptionDefinition("i", new OptionDefinition(OptionValueType.NONE, "Filters are case-insensitive (case-sensitive by default)"));
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.NONE, "Filters matches more loosely, i.e. it's considered a match if just a part of a value matches the pattern, not necessarily the whole value"));
        this.addOptionDefinition("s", new OptionDefinition(OptionValueType.NONE, "Sorts relationships by type."));
        this.addOptionDefinition("m", new OptionDefinition(OptionValueType.MAY, "Display a maximum of M relationships per type (default 10 if no value given)"));
    }

    @Override
    public String getDescription() {
        return "Lists the contents of the current node or relationship. Optionally supply\nnode id for listing a certain node using \"ls <node-id>\"";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        boolean brief = parser.options().containsKey("b");
        boolean verbose = parser.options().containsKey("v");
        boolean quiet = parser.options().containsKey("q");
        if (verbose && quiet) {
            verbose = false;
            quiet = false;
        }
        boolean displayProperties = parser.options().containsKey("p");
        boolean displayRelationships = parser.options().containsKey("r");
        boolean caseInsensitiveFilters = parser.options().containsKey("i");
        boolean looseFilters = parser.options().containsKey("l");
        Map<String, Object> filterMap = Ls.parseFilter(parser.options().get("f"), out);
        if (!displayProperties && !displayRelationships) {
            displayProperties = true;
            displayRelationships = true;
        }
        NodeOrRelationship thing = null;
        thing = parser.arguments().isEmpty() ? this.getCurrent(session) : NodeOrRelationship.wrap(this.getNodeById(Long.parseLong(parser.arguments().get(0))));
        if (displayProperties) {
            this.displayProperties(thing, out, verbose, quiet, filterMap, caseInsensitiveFilters, looseFilters, brief);
        }
        if (displayRelationships) {
            if (thing.isNode()) {
                this.displayRelationships(parser, thing, session, out, verbose, quiet, filterMap, caseInsensitiveFilters, looseFilters, brief);
            } else {
                this.displayNodes(parser, thing, session, out);
            }
        }
        return Continuation.INPUT_COMPLETE;
    }

    private void displayNodes(AppCommandParser parser, NodeOrRelationship thing, Session session, Output out) throws RemoteException, ShellException {
        Relationship rel = thing.asRelationship();
        out.println((Serializable)((Object)(Ls.getDisplayName(this.getServer(), session, rel.getStartNode(), false) + " --" + Ls.getDisplayName(this.getServer(), session, rel, true, false) + "-> " + Ls.getDisplayName(this.getServer(), session, rel.getEndNode(), false))));
    }

    private Iterable<String> sortKeys(Iterable<String> source) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : source) {
            list.add(item);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String item1, String item2) {
                return item1.toLowerCase().compareTo(item2.toLowerCase());
            }
        });
        return list;
    }

    private void displayProperties(NodeOrRelationship thing, Output out, boolean verbose, boolean quiet, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters, boolean brief) throws RemoteException {
        int longestKey = Ls.findLongestKey(thing);
        int count = 0;
        for (String key : this.sortKeys(thing.getPropertyKeys())) {
            Object value;
            if (!Ls.filterMatches(filterMap, caseInsensitiveFilters, looseFilters, key, value = thing.getProperty(key))) continue;
            ++count;
            if (brief) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("*" + key);
            if (!quiet) {
                builder.append(this.multiply(" ", longestKey - key.length() + 1));
                builder.append("=" + Ls.format(value, true));
                if (verbose) {
                    builder.append(" (" + Ls.getNiceType(value) + ")");
                }
            }
            out.println((Serializable)((Object)builder.toString()));
        }
        if (brief) {
            out.println((Serializable)((Object)("Property count: " + count)));
        }
    }

    private void displayRelationships(AppCommandParser parser, NodeOrRelationship thing, Session session, Output out, boolean verbose, boolean quiet, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters, boolean brief) throws ShellException, RemoteException {
        boolean sortByType = parser.options().containsKey("s");
        Node node = thing.asNode();
        Iterable<Relationship> relationships = this.getRelationships(node, filterMap, caseInsensitiveFilters, looseFilters, sortByType | brief);
        if (brief) {
            Iterator<Relationship> iterator = relationships.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            Relationship sampleRelationship = iterator.next();
            RelationshipType lastType = sampleRelationship.getType();
            int currentCounter = 1;
            while (iterator.hasNext()) {
                Relationship rel = iterator.next();
                if (!rel.isType(lastType)) {
                    this.displayBriefRelationships(thing, session, out, sampleRelationship, currentCounter);
                    sampleRelationship = rel;
                    lastType = sampleRelationship.getType();
                    currentCounter = 1;
                    continue;
                }
                ++currentCounter;
            }
            this.displayBriefRelationships(thing, session, out, sampleRelationship, currentCounter);
        } else {
            Iterator<Relationship> iterator = relationships.iterator();
            if (parser.options().containsKey("m")) {
                iterator = this.wrapInLimitingIterator(parser, iterator, filterMap, caseInsensitiveFilters, looseFilters);
            }
            while (iterator.hasNext()) {
                Relationship rel = iterator.next();
                StringBuffer buf = new StringBuffer(Ls.getDisplayName(this.getServer(), session, thing, true));
                String relDisplay = quiet ? "" : Ls.getDisplayName(this.getServer(), session, rel, verbose, true);
                buf.append(Ls.withArrows(rel, relDisplay, thing.asNode()));
                buf.append(Ls.getDisplayName(this.getServer(), session, rel.getOtherNode(node), true));
                out.println(buf);
            }
        }
    }

    private Iterator<Relationship> wrapInLimitingIterator(AppCommandParser parser, Iterator<Relationship> iterator, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException {
        final AtomicBoolean handBreak = new AtomicBoolean();
        int maxRelsPerType = parser.optionAsNumber("m", 10).intValue();
        Map<String, Direction> types = Ls.filterMapToTypes((GraphDatabaseService)this.getServer().getDb(), Direction.BOTH, filterMap, caseInsensitiveFilters, looseFilters);
        return new FilteringIterator<Relationship>(iterator, (Predicate)new LimitPerTypeFilter(maxRelsPerType, types, handBreak)){

            protected Relationship fetchNextOrNull() {
                return handBreak.get() ? null : (Relationship)super.fetchNextOrNull();
            }
        };
    }

    private Iterable<Relationship> getRelationships(Node node, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters, boolean sortByType) throws ShellException {
        if (sortByType) {
            SingleNodePath nodeAsPath = new SingleNodePath(node);
            return Ls.toSortedExpander((GraphDatabaseService)this.getServer().getDb(), Direction.BOTH, filterMap, caseInsensitiveFilters, looseFilters).expand((Path)nodeAsPath, Traversal.NO_BRANCH_STATE);
        }
        if (filterMap.isEmpty()) {
            return node.getRelationships();
        }
        SingleNodePath nodeAsPath = new SingleNodePath(node);
        return Ls.toExpander((GraphDatabaseService)this.getServer().getDb(), Direction.BOTH, filterMap, caseInsensitiveFilters, looseFilters).expand((Path)nodeAsPath, Traversal.NO_BRANCH_STATE);
    }

    private void displayBriefRelationships(NodeOrRelationship thing, Session session, Output out, Relationship sampleRelationship, int count) throws ShellException, RemoteException {
        String relDisplay = Ls.withArrows(sampleRelationship, Ls.getDisplayName(this.getServer(), session, sampleRelationship, false, true), thing.asNode());
        out.println((Serializable)((Object)(Ls.getDisplayName(this.getServer(), session, thing, true) + relDisplay + " x" + count)));
    }

    private static String getNiceType(Object value) {
        return Set.getValueTypeName(value.getClass());
    }

    private static int findLongestKey(NodeOrRelationship thing) {
        int length = 0;
        for (String key : thing.getPropertyKeys()) {
            if (key.length() <= length) continue;
            length = key.length();
        }
        return length;
    }

    private static class LimitPerTypeFilter
    implements Predicate<Relationship> {
        private final int maxRelsPerType;
        private final Map<String, AtomicInteger> encounteredRelationships = new HashMap<String, AtomicInteger>();
        private int typesMaxedOut = 0;
        private final AtomicBoolean iterationHalted;

        public LimitPerTypeFilter(int maxRelsPerType, Map<String, Direction> types, AtomicBoolean handBreak) {
            this.maxRelsPerType = maxRelsPerType;
            this.iterationHalted = handBreak;
            for (String type : types.keySet()) {
                this.encounteredRelationships.put(type, new AtomicInteger());
            }
        }

        public boolean accept(Relationship item) {
            AtomicInteger counter = this.encounteredRelationships.get(item.getType().name());
            int count = counter.get();
            if (count < this.maxRelsPerType) {
                if (counter.incrementAndGet() == this.maxRelsPerType) {
                    counter.incrementAndGet();
                    if (++this.typesMaxedOut >= this.encounteredRelationships.size()) {
                        this.iterationHalted.set(true);
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
    }
}

