/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.ScriptEngineViaReflection;

public class Eval
extends GraphDatabaseApp {
    private ScriptEngineViaReflection scripting;

    @Override
    public String getDescription() {
        return "Pass JavaScript to be executed on the shell server, directly on the database. There are predefined variables you can use:\n  db      : the GraphDatabaseService on the server\n  out     : output back to you (the shell client)\n  current : current node or relationship you stand on\n\nUsage:\n  eval db.getReferenceNode().getProperty(\"name\")\n  \n  eval\n  > nodes = db.getAllNodes().iterator();\n  > while ( nodes.hasNext() )\n  >   out.println( \"\" + nodes.next() );\n  >\nSo either a one-liner or type 'eval' to enter multi-line mode, where an empty line denotes the end";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        boolean satisfied;
        boolean bl = satisfied = parser.getLine().endsWith("\n") || parser.getLineWithoutApp().length() > 0 && parser.getLine().indexOf(10) == -1;
        if (!satisfied) {
            return Continuation.INPUT_INCOMPLETE;
        }
        this.scripting = this.scripting != null ? this.scripting : new ScriptEngineViaReflection(this.getServer());
        String javascriptCode = parser.getLineWithoutApp();
        javascriptCode = ScriptEngineViaReflection.decorateWithImports(javascriptCode, STANDARD_EVAL_IMPORTS);
        Object scriptEngine = this.scripting.getJavascriptEngine();
        this.scripting.addDefaultContext(scriptEngine, session, out);
        Object result = this.scripting.interpret(scriptEngine, javascriptCode);
        if (result != null) {
            out.println((Serializable)((Object)result.toString()));
        }
        return Continuation.INPUT_COMPLETE;
    }
}

