/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;

public class ReadOnlyGraphDatabaseProxy
implements GraphDatabaseService,
GraphDatabaseAPI,
IndexManager {
    private final GraphDatabaseAPI actual;
    private final org.neo4j.graphdb.Transaction tx = new org.neo4j.graphdb.Transaction(){

        public void success() {
        }

        public void failure() {
        }

        public void finish() {
        }

        public Lock acquireWriteLock(PropertyContainer entity) {
            return PlaceboTransaction.NO_LOCK;
        }

        public Lock acquireReadLock(PropertyContainer entity) {
            return PlaceboTransaction.NO_LOCK;
        }
    };
    private final TransactionBuilder txBuilder = new TransactionBuilder(){

        public TransactionBuilder unforced() {
            throw new UnsupportedOperationException();
        }

        public org.neo4j.graphdb.Transaction begin() {
            return ReadOnlyGraphDatabaseProxy.this.beginTx();
        }
    };
    private final AbstractTransactionManager txManager = new AbstractTransactionManager(){

        public void stop() throws Throwable {
        }

        public void start() throws Throwable {
        }

        public void shutdown() throws Throwable {
        }

        public void init() throws Throwable {
        }

        public Transaction suspend() throws SystemException {
            return null;
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            throw new ReadOnlyDbException();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            throw new ReadOnlyDbException();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new ReadOnlyDbException();
        }

        public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
            throw new ReadOnlyDbException();
        }

        public Transaction getTransaction() throws SystemException {
            throw new ReadOnlyDbException();
        }

        public int getStatus() throws SystemException {
            return 6;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            throw new ReadOnlyDbException();
        }

        public void begin() throws NotSupportedException, SystemException {
            throw new ReadOnlyDbException();
        }
    };

    public ReadOnlyGraphDatabaseProxy(GraphDatabaseAPI graphDb) {
        this.actual = graphDb;
    }

    public GraphDatabaseService getActualGraphDb() {
        return this.actual;
    }

    public Node readOnly(Node actual) {
        return new ReadOnlyNodeProxy(actual);
    }

    public Relationship readOnly(Relationship actual) {
        return new ReadOnlyRelationshipProxy(actual);
    }

    private static <T> T readOnly() {
        throw new UnsupportedOperationException("Read only Graph Database!");
    }

    public org.neo4j.graphdb.Transaction beginTx() {
        return this.tx;
    }

    public Node createNode() {
        return (Node)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public boolean enableRemoteShell() {
        throw new UnsupportedOperationException("Cannot enable Remote Shell from Remote Shell");
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.enableRemoteShell();
    }

    public Iterable<Node> getAllNodes() {
        return this.nodes(this.actual.getAllNodes());
    }

    public Node getNodeById(long id) {
        return new ReadOnlyNodeProxy(this.actual.getNodeById(id));
    }

    public Node getReferenceNode() {
        return new ReadOnlyNodeProxy(this.actual.getReferenceNode());
    }

    public Relationship getRelationshipById(long id) {
        return new ReadOnlyRelationshipProxy(this.actual.getRelationshipById(id));
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.actual.getRelationshipTypes();
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return (KernelEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return (TransactionEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public void shutdown() {
        this.actual.shutdown();
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return (KernelEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return (TransactionEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public Iterable<Node> nodes(Iterable<Node> nodes) {
        return new IterableWrapper<Node, Node>(nodes){

            protected Node underlyingObjectToObject(Node node) {
                return new ReadOnlyNodeProxy(node);
            }
        };
    }

    public Iterable<Relationship> relationships(Iterable<Relationship> relationships) {
        return new IterableWrapper<Relationship, Relationship>(relationships){

            protected Relationship underlyingObjectToObject(Relationship relationship) {
                return new ReadOnlyRelationshipProxy(relationship);
            }
        };
    }

    public boolean existsForNodes(String indexName) {
        return this.actual.index().existsForNodes(indexName);
    }

    public Index<Node> forNodes(String indexName) {
        return new ReadOnlyNodeIndexProxy((Index<Node>)this.actual.index().forNodes(indexName, null));
    }

    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        return new ReadOnlyNodeIndexProxy((Index<Node>)this.actual.index().forNodes(indexName, customConfiguration));
    }

    public String[] nodeIndexNames() {
        return this.actual.index().nodeIndexNames();
    }

    public boolean existsForRelationships(String indexName) {
        return this.actual.index().existsForRelationships(indexName);
    }

    public RelationshipIndex forRelationships(String indexName) {
        return new ReadOnlyRelationshipIndexProxy(this.actual.index().forRelationships(indexName, null));
    }

    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        return new ReadOnlyRelationshipIndexProxy(this.actual.index().forRelationships(indexName, customConfiguration));
    }

    public String[] relationshipIndexNames() {
        return this.actual.index().relationshipIndexNames();
    }

    public IndexManager index() {
        return this;
    }

    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        return this.actual.index().getConfiguration(index);
    }

    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
        throw new ReadOnlyDbException();
    }

    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        throw new ReadOnlyDbException();
    }

    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.actual.index().getNodeAutoIndexer();
    }

    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.actual.index().getRelationshipAutoIndexer();
    }

    public NodeManager getNodeManager() {
        return this.actual.getNodeManager();
    }

    public LockReleaser getLockReleaser() {
        return this.actual.getLockReleaser();
    }

    public LockManager getLockManager() {
        return this.actual.getLockManager();
    }

    public XaDataSourceManager getXaDataSourceManager() {
        return this.actual.getXaDataSourceManager();
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public DiagnosticsManager getDiagnosticsManager() {
        return this.actual.getDiagnosticsManager();
    }

    public StringLogger getMessageLog() {
        return this.actual.getMessageLog();
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.actual.getRelationshipTypeHolder();
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.actual.getIdGeneratorFactory();
    }

    public String getStoreDir() {
        return this.actual.getStoreDir();
    }

    public KernelData getKernelData() {
        return this.actual.getKernelData();
    }

    public <T> T getSingleManagementBean(Class<T> type) {
        return (T)this.actual.getSingleManagementBean(type);
    }

    public TransactionBuilder tx() {
        return this.actual.tx();
    }

    public PersistenceSource getPersistenceSource() {
        return this.actual.getPersistenceSource();
    }

    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.actual.getManagementBeans(type);
    }

    public KernelPanicEventGenerator getKernelPanicGenerator() {
        return this.actual.getKernelPanicGenerator();
    }

    public Guard getGuard() {
        return this.actual.getGuard();
    }

    public StoreId getStoreId() {
        return this.actual.getStoreId();
    }

    public TxIdGenerator getTxIdGenerator() {
        return this.actual.getTxIdGenerator();
    }

    private static class ReadOnlyIndexHitsProxy<T extends PropertyContainer>
    implements IndexHits<T> {
        private final ReadOnlyIndexProxy<T, ?> index;
        private final IndexHits<T> actual;

        ReadOnlyIndexHitsProxy(ReadOnlyIndexProxy<T, ?> index, IndexHits<T> actual) {
            this.index = index;
            this.actual = actual;
        }

        public void close() {
            this.actual.close();
        }

        public T getSingle() {
            return (T)this.index.wrap((PropertyContainer)this.actual.getSingle());
        }

        public int size() {
            return this.actual.size();
        }

        public boolean hasNext() {
            return this.actual.hasNext();
        }

        public T next() {
            return (T)this.index.wrap((PropertyContainer)this.actual.next());
        }

        public void remove() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public Iterator<T> iterator() {
            return this;
        }

        public float currentScore() {
            return this.actual.currentScore();
        }
    }

    class ReadOnlyRelationshipIndexProxy
    extends ReadOnlyIndexProxy<Relationship, RelationshipIndex>
    implements RelationshipIndex {
        ReadOnlyRelationshipIndexProxy(RelationshipIndex actual) {
            super(ReadOnlyGraphDatabaseProxy.this, (Index)actual);
        }

        @Override
        Relationship wrap(Relationship actual) {
            return ReadOnlyGraphDatabaseProxy.this.readOnly(actual);
        }

        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).get(key, valueOrNull, startNodeOrNull, endNodeOrNull));
        }

        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).query(key, queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull));
        }

        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).query(queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull));
        }

        public String getName() {
            return ((RelationshipIndex)this.actual).getName();
        }

        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }
    }

    class ReadOnlyNodeIndexProxy
    extends ReadOnlyIndexProxy<Node, Index<Node>> {
        ReadOnlyNodeIndexProxy(Index<Node> actual) {
            super(ReadOnlyGraphDatabaseProxy.this, actual);
        }

        @Override
        Node wrap(Node actual) {
            return ReadOnlyGraphDatabaseProxy.this.readOnly(actual);
        }

        public String getName() {
            return this.actual.getName();
        }

        public Class<Node> getEntityType() {
            return Node.class;
        }
    }

    static abstract class ReadOnlyIndexProxy<T extends PropertyContainer, I extends Index<T>>
    implements Index<T> {
        final I actual;
        final /* synthetic */ ReadOnlyGraphDatabaseProxy this$0;

        ReadOnlyIndexProxy(I actual) {
            this.this$0 = var1_1;
            this.actual = actual;
        }

        abstract T wrap(T var1);

        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void add(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public T putIfAbsent(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
            return null;
        }

        public IndexHits<T> get(String key, Object value) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.get(key, value));
        }

        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.query(key, queryOrQueryObject));
        }

        public IndexHits<T> query(Object queryOrQueryObject) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.query(queryOrQueryObject));
        }

        public void remove(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void remove(T entity, String key) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void remove(T entity) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public boolean isWriteable() {
            return false;
        }

        public GraphDatabaseService getGraphDatabase() {
            return this.actual.getGraphDatabase();
        }
    }

    private class ReadOnlyRelationshipProxy
    implements Relationship {
        private final Relationship actual;

        ReadOnlyRelationshipProxy(Relationship actual) {
            this.actual = actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Relationship && ((Relationship)obj).getId() == this.getId();
        }

        public String toString() {
            return this.actual.toString();
        }

        public long getId() {
            return this.actual.getId();
        }

        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public Node getEndNode() {
            return new ReadOnlyNodeProxy(this.actual.getEndNode());
        }

        public Node[] getNodes() {
            return new Node[]{this.getStartNode(), this.getEndNode()};
        }

        public Node getOtherNode(Node node) {
            return new ReadOnlyNodeProxy(this.actual.getOtherNode(node));
        }

        public Node getStartNode() {
            return new ReadOnlyNodeProxy(this.actual.getStartNode());
        }

        public RelationshipType getType() {
            return this.actual.getType();
        }

        public boolean isType(RelationshipType type) {
            return this.actual.isType(type);
        }

        public GraphDatabaseService getGraphDatabase() {
            return ReadOnlyGraphDatabaseProxy.this;
        }

        public Object getProperty(String key) {
            return this.actual.getProperty(key);
        }

        public Object getProperty(String key, Object defaultValue) {
            return this.actual.getProperty(key, defaultValue);
        }

        public Iterable<String> getPropertyKeys() {
            return this.actual.getPropertyKeys();
        }

        public Iterable<Object> getPropertyValues() {
            return this.actual.getPropertyValues();
        }

        public boolean hasProperty(String key) {
            return this.actual.hasProperty(key);
        }

        public Object removeProperty(String key) {
            return ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void setProperty(String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }
    }

    private class ReadOnlyNodeProxy
    implements Node {
        private final Node actual;

        ReadOnlyNodeProxy(Node actual) {
            this.actual = actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Node && ((Node)obj).getId() == this.getId();
        }

        public String toString() {
            return this.actual.toString();
        }

        public long getId() {
            return this.actual.getId();
        }

        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            return (Relationship)ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public Iterable<Relationship> getRelationships() {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships());
        }

        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(types));
        }

        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(direction, types));
        }

        public Iterable<Relationship> getRelationships(Direction dir) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(dir));
        }

        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(type, dir));
        }

        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return new ReadOnlyRelationshipProxy(this.actual.getSingleRelationship(type, dir));
        }

        public boolean hasRelationship() {
            return this.actual.hasRelationship();
        }

        public boolean hasRelationship(RelationshipType ... types) {
            return this.actual.hasRelationship(types);
        }

        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return this.actual.hasRelationship(direction, types);
        }

        public boolean hasRelationship(Direction dir) {
            return this.actual.hasRelationship(dir);
        }

        public boolean hasRelationship(RelationshipType type, Direction dir) {
            return this.actual.hasRelationship(type, dir);
        }

        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
            return OldTraverserWrapper.traverse((Node)this, (Traverser.Order)traversalOrder, (StopEvaluator)stopEvaluator, (ReturnableEvaluator)returnableEvaluator, (Object[])new Object[]{relationshipType, direction});
        }

        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
            return OldTraverserWrapper.traverse((Node)this, (Traverser.Order)traversalOrder, (StopEvaluator)stopEvaluator, (ReturnableEvaluator)returnableEvaluator, (Object[])new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
        }

        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
            return OldTraverserWrapper.traverse((Node)this, (Traverser.Order)traversalOrder, (StopEvaluator)stopEvaluator, (ReturnableEvaluator)returnableEvaluator, (Object[])relationshipTypesAndDirections);
        }

        public GraphDatabaseService getGraphDatabase() {
            return ReadOnlyGraphDatabaseProxy.this;
        }

        public Object getProperty(String key) {
            return this.actual.getProperty(key);
        }

        public Object getProperty(String key, Object defaultValue) {
            return this.actual.getProperty(key, defaultValue);
        }

        public Iterable<String> getPropertyKeys() {
            return this.actual.getPropertyKeys();
        }

        public Iterable<Object> getPropertyValues() {
            return this.actual.getPropertyValues();
        }

        public boolean hasProperty(String key) {
            return this.actual.hasProperty(key);
        }

        public Object removeProperty(String key) {
            return ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void setProperty(String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }
    }
}

