/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.TabCompletion;
import org.neo4j.shell.Welcome;
import org.neo4j.shell.impl.RemotelyAvailableServer;

public abstract class AbstractServer
implements ShellServer {
    private ShellServer remoteEndPoint;
    public static final String DEFAULT_NAME = "shell";
    public static final int DEFAULT_PORT = 1337;
    private final Map<Serializable, Session> clientSessions = new ConcurrentHashMap<Serializable, Session>();
    private final AtomicInteger nextClientId = new AtomicInteger();

    @Override
    public String getName() {
        return DEFAULT_NAME;
    }

    @Override
    public Serializable interpretVariable(Serializable clientID, String key) throws ShellException, RemoteException {
        return (Serializable)this.getClientSession(clientID).get(key);
    }

    protected Serializable newClientId() {
        return Integer.valueOf(this.nextClientId.incrementAndGet());
    }

    @Override
    public Welcome welcome(Map<String, Serializable> initialSession) throws RemoteException {
        Serializable clientId = this.newClientId();
        if (this.clientSessions.containsKey(clientId)) {
            throw new IllegalStateException("Client " + clientId + " already initialized");
        }
        Session session = this.newSession(clientId, initialSession);
        this.clientSessions.put(clientId, session);
        try {
            return new Welcome(this.getWelcomeMessage(), clientId, this.getPrompt(session));
        }
        catch (ShellException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private Session newSession(Serializable id, Map<String, Serializable> initialSession) {
        Session session = new Session(id);
        this.initialPopulateSession(session);
        for (Map.Entry<String, Serializable> entry : initialSession.entrySet()) {
            session.set(entry.getKey(), entry.getValue());
        }
        return session;
    }

    protected void initialPopulateSession(Session session) {
    }

    protected String getPrompt(Session session) throws ShellException {
        return "sh$ ";
    }

    protected String getWelcomeMessage() {
        return "Welcome to the shell";
    }

    public Session getClientSession(Serializable clientID) {
        Session session = this.clientSessions.get(clientID);
        if (session == null) {
            throw new IllegalStateException("Client " + clientID + " not initialized");
        }
        return session;
    }

    @Override
    public void leave(Serializable clientID) throws RemoteException {
        if (this.clientSessions.remove(clientID) == null) {
            throw new IllegalStateException("Client " + clientID + " not initialized");
        }
    }

    @Override
    public synchronized void shutdown() throws RemoteException {
        if (this.remoteEndPoint != null) {
            this.remoteEndPoint.shutdown();
            this.remoteEndPoint = null;
        }
    }

    @Override
    public synchronized void makeRemotelyAvailable(int port, String name) throws RemoteException {
        if (this.remoteEndPoint == null) {
            this.remoteEndPoint = new RemotelyAvailableServer(this);
        }
        this.remoteEndPoint.makeRemotelyAvailable(port, name);
    }

    @Override
    public String[] getAllAvailableCommands() {
        return new String[0];
    }

    public TabCompletion tabComplete(String partOfLine, Session session) throws ShellException, RemoteException {
        return new TabCompletion(Collections.<String>emptyList(), 0);
    }

    @Override
    public void setSessionVariable(Serializable clientID, String key, Object value) {
        this.getClientSession(clientID).set(key, value);
    }
}

