/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps;

import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.impl.AbstractApp;

public class Export
extends AbstractApp {
    @Override
    public String getDescription() {
        return "Sets an environment variable. Usage: export <key>=<value>\nF.ex: export NAME=\"Mattias Persson\"";
    }

    public static String[] splitInKeyEqualsValue(String string) throws ShellException {
        int index = string.indexOf(61);
        if (index == -1) {
            throw new ShellException("Invalid format <key>=<value>");
        }
        String key = string.substring(0, index);
        String value = string.substring(index + 1);
        if (value.startsWith("'") || value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("'") || value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return new String[]{key, value};
    }

    @Override
    public Continuation execute(AppCommandParser parser, Session session, Output out) throws ShellException {
        String[] keyValue = Export.splitInKeyEqualsValue(parser.getLineWithoutApp());
        String key = keyValue[0];
        String value = keyValue[1];
        if (value == null || value.trim().length() == 0) {
            session.remove(key);
        } else {
            session.set(key, value);
        }
        return Continuation.INPUT_COMPLETE;
    }
}

