/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.RemoteClient;
import org.neo4j.shell.impl.RmiLocation;
import org.neo4j.shell.impl.SameJvmClient;

public abstract class ShellLobby {
    public static ShellServer newServer(Class<? extends ShellServer> cls) throws ShellException {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ShellClient newClient(ShellServer server) {
        return ShellLobby.newClient(server, new HashMap<String, Serializable>());
    }

    public static ShellClient newClient(ShellServer server, Map<String, Serializable> initialSession) {
        return new SameJvmClient(initialSession, server);
    }

    public static ShellClient newClient(int port, String name) throws ShellException {
        return ShellLobby.newClient("localhost", port, name);
    }

    public static ShellClient newClient(int port) throws ShellException {
        return ShellLobby.newClient("localhost", port);
    }

    public static ShellClient newClient(String host, int port, String name) throws ShellException {
        return ShellLobby.newClient(RmiLocation.location(host, port, name));
    }

    public static ShellClient newClient(String host, int port) throws ShellException {
        return ShellLobby.newClient(host, port, "shell");
    }

    public static ShellClient newClient(RmiLocation serverLocation) throws ShellException {
        return ShellLobby.newClient(serverLocation, new HashMap<String, Serializable>());
    }

    public static ShellClient newClient(RmiLocation serverLocation, Map<String, Serializable> initialSession) throws ShellException {
        return new RemoteClient(initialSession, serverLocation);
    }

    public static ShellClient newClient(String host) throws ShellException {
        return ShellLobby.newClient(host, 1337, "shell");
    }

    public static ShellClient newClient() throws ShellException {
        return ShellLobby.newClient("localhost", 1337, "shell");
    }
}

