/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ShellException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String stackTraceAsString;

    public ShellException(String message) {
        this(message, (String)null);
    }

    private ShellException(String message, Throwable cause) {
        super(message, cause);
        this.stackTraceAsString = null;
    }

    private ShellException(String message, String stackTraceAsString) {
        super(message);
        this.stackTraceAsString = stackTraceAsString;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.stackTraceAsString != null) {
            s.print(this.stackTraceAsString);
        } else if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.stackTraceAsString != null) {
            s.print(this.stackTraceAsString);
        } else if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public static ShellException wrapCause(Throwable cause) {
        if (ShellException.isCompletelyRecognizedException(cause)) {
            return cause instanceof ShellException ? (ShellException)cause : new ShellException(ShellException.getFirstMessage(cause), cause);
        }
        return ShellException.softWrap(cause);
    }

    private static ShellException softWrap(Throwable cause) {
        String stackTraceAsString = ShellException.stackTraceAsString(cause);
        String message = ShellException.getFirstMessage(cause);
        if (!(cause instanceof ShellException)) {
            message = cause.getClass().getSimpleName() + ": " + message;
        }
        return new ShellException(message, stackTraceAsString);
    }

    public static String getFirstMessage(Throwable cause) {
        while (cause != null) {
            String message = cause.getMessage();
            if (message != null && message.length() > 0) {
                return message;
            }
            cause = cause.getCause();
        }
        return null;
    }

    private static boolean isCompletelyRecognizedException(Throwable e) {
        String packageName = e.getClass().getPackage().getName();
        if (!(e instanceof ShellException) && !packageName.startsWith("java.")) {
            return false;
        }
        Throwable cause = e.getCause();
        return cause == null ? true : ShellException.isCompletelyRecognizedException(cause);
    }

    public static String stackTraceAsString(Throwable cause) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)writer, false);
        cause.printStackTrace(printWriter);
        printWriter.close();
        return writer.getBuffer().toString();
    }
}

