/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import org.neo4j.ogm.typeconversion.AttributeConverter;

public class NumberStringConverter
implements AttributeConverter<Number, String> {
    private final Class<? extends Number> numberClass;

    public NumberStringConverter(Class<? extends Number> numberClass) {
        this.numberClass = numberClass;
    }

    @Override
    public String toGraphProperty(Number value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Number toEntityAttribute(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.numberClass.getDeclaredConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Conversion failed!", e);
        }
    }
}

