/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class NumberCollectionStringConverter
implements AttributeConverter<Collection<Number>, String[]> {
    private final Class<? extends Number> numberClass;
    private final Class<? extends Collection> collectionClass;

    public NumberCollectionStringConverter(Class<? extends Number> numberClass, Class<? extends Collection> collectionClass) {
        this.numberClass = numberClass;
        this.collectionClass = collectionClass;
    }

    @Override
    public String[] toGraphProperty(Collection<Number> value) {
        if (value == null) {
            return null;
        }
        String[] values = new String[value.size()];
        int i = 0;
        for (Number num : value) {
            values[i++] = num.toString();
        }
        return values;
    }

    @Override
    public Collection<Number> toEntityAttribute(String[] stringValues) {
        if (stringValues == null) {
            return null;
        }
        ArrayList<Number> values = null;
        if (List.class.isAssignableFrom(this.collectionClass)) {
            values = new ArrayList(stringValues.length);
        } else if (Vector.class.isAssignableFrom(this.collectionClass)) {
            values = new Vector(stringValues.length);
        } else if (Set.class.isAssignableFrom(this.collectionClass)) {
            values = new HashSet(stringValues.length);
        } else {
            return null;
        }
        try {
            for (String value : stringValues) {
                values.add(this.numberClass.getDeclaredConstructor(String.class).newInstance(value));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return values;
    }
}

