/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class EnumCollectionStringConverter
implements AttributeConverter<Collection<Enum>, String[]> {
    private final Class<? extends Enum> enumClass;
    private final Class<? extends Collection> collectionClass;

    public EnumCollectionStringConverter(Class<? extends Enum> enumClass, Class<? extends Collection> collectionClass) {
        this.enumClass = enumClass;
        this.collectionClass = collectionClass;
    }

    @Override
    public String[] toGraphProperty(Collection<Enum> value) {
        if (value == null) {
            return null;
        }
        String[] values = new String[value.size()];
        int i = 0;
        for (Enum e : value) {
            values[i++] = e.name();
        }
        return values;
    }

    @Override
    public Collection<Enum> toEntityAttribute(String[] stringValues) {
        ArrayList<Enum> values;
        if (stringValues == null) {
            return null;
        }
        if (List.class.isAssignableFrom(this.collectionClass)) {
            values = new ArrayList(stringValues.length);
        } else if (Vector.class.isAssignableFrom(this.collectionClass)) {
            values = new Vector(stringValues.length);
        } else if (Set.class.isAssignableFrom(this.collectionClass)) {
            values = new HashSet(stringValues.length);
        } else {
            return null;
        }
        for (String value : stringValues) {
            values.add(Enum.valueOf(this.enumClass, value.toString()));
        }
        return values;
    }
}

