/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.neo4j.ogm.authentication.CredentialsService;
import org.neo4j.ogm.authentication.HttpRequestAuthorization;
import org.neo4j.ogm.authentication.Neo4jCredentials;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.mapper.MappingContext;
import org.neo4j.ogm.session.result.ErrorsException;
import org.neo4j.ogm.session.result.ResultProcessingException;
import org.neo4j.ogm.session.transaction.LongTransaction;
import org.neo4j.ogm.session.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    private final CloseableHttpClient httpClient;
    private final String url;
    private final Neo4jCredentials credentials;
    private static final ThreadLocal<Transaction> transaction = new ThreadLocal();

    public TransactionManager(CloseableHttpClient httpClient, String server) {
        this.url = this.transactionRequestEndpoint(server);
        this.httpClient = httpClient;
        this.credentials = CredentialsService.userNameAndPassword();
        transaction.remove();
    }

    public TransactionManager(CloseableHttpClient httpClient, String server, UsernamePasswordCredentials credentials) {
        this.url = this.transactionRequestEndpoint(server);
        this.httpClient = httpClient;
        this.credentials = credentials;
        transaction.remove();
    }

    public Transaction openTransaction(MappingContext mappingContext) {
        String transactionEndpoint = this.newTransactionEndpointUrl();
        this.logger.debug("Creating new transaction with endpoint " + transactionEndpoint);
        transaction.set(new LongTransaction(mappingContext, transactionEndpoint, this));
        return transaction.get();
    }

    public void rollback(Transaction tx) {
        String url = tx.url();
        this.logger.debug("DELETE " + url);
        HttpDelete request = new HttpDelete(url);
        this.executeRequest((HttpRequestBase)request);
        transaction.remove();
    }

    public void commit(Transaction tx) {
        String url = tx.url() + "/commit";
        this.logger.debug("POST " + url);
        HttpPost request = new HttpPost(url);
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
        this.executeRequest((HttpRequestBase)request);
        transaction.remove();
    }

    public Transaction getCurrentTransaction() {
        return transaction.get();
    }

    private HttpResponse executeRequest(HttpRequestBase request) {
        try {
            request.setHeader((Header)new BasicHeader("Accept", "application/json;charset=UTF-8"));
            HttpRequestAuthorization.authorize(request, this.credentials);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            this.logger.debug("Status code: " + statusLine.getStatusCode());
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String responseText = EntityUtils.toString((HttpEntity)responseEntity);
                this.logger.debug(responseText);
                EntityUtils.consume((HttpEntity)responseEntity);
                if (responseText.contains("\"errors\":[{") || responseText.contains("\"errors\": [{")) {
                    throw new ErrorsException(responseText);
                }
            } else {
                request.releaseConnection();
            }
            return response;
        }
        catch (Exception e) {
            throw new ResultProcessingException("Failed to execute request: ", e);
        }
    }

    private String newTransactionEndpointUrl() {
        this.logger.debug("POST " + this.url);
        HttpPost request = new HttpPost(this.url);
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        Header location = response.getHeaders("Location")[0];
        return location.getValue();
    }

    private String transactionRequestEndpoint(String server) {
        if (server == null) {
            return server;
        }
        String url = server;
        if (!server.endsWith("/")) {
            url = url + "/";
        }
        return url + "db/data/transaction";
    }
}

