/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.compiler.CypherContext;
import org.neo4j.ogm.mapper.MappedRelationship;
import org.neo4j.ogm.mapper.MappingContext;
import org.neo4j.ogm.mapper.TransientRelationship;
import org.neo4j.ogm.session.transaction.Transaction;
import org.neo4j.ogm.session.transaction.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTransaction
implements Transaction {
    private final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private final MappingContext mappingContext;
    private final String url;
    private final boolean autocommit;
    private final List<CypherContext> contexts;
    private Transaction.Status status = Transaction.Status.OPEN;

    public SimpleTransaction(MappingContext mappingContext, String url) {
        this.mappingContext = mappingContext;
        this.url = url;
        this.autocommit = url.endsWith("/commit");
        this.contexts = new ArrayList<CypherContext>();
    }

    @Override
    public final void append(CypherContext context) {
        this.logger.debug("Appending transaction context " + context);
        if (this.status == Transaction.Status.OPEN || this.status == Transaction.Status.PENDING) {
            this.contexts.add(context);
            this.status = Transaction.Status.PENDING;
            if (this.autocommit) {
                this.commit();
            }
        } else {
            throw new TransactionException("Transaction is no longer open. Cannot accept new operations");
        }
    }

    @Override
    public final String url() {
        return this.url;
    }

    @Override
    public void rollback() {
        this.logger.debug("rollback invoked");
        if (this.status != Transaction.Status.OPEN && this.status != Transaction.Status.PENDING) {
            throw new TransactionException("Transaction is no longer open. Cannot rollback");
        }
        this.contexts.clear();
        this.status = Transaction.Status.ROLLEDBACK;
    }

    @Override
    public void commit() {
        this.logger.debug("commit invoked");
        if (this.status != Transaction.Status.OPEN && this.status != Transaction.Status.PENDING) {
            throw new TransactionException("Transaction is no longer open. Cannot commit");
        }
        this.synchroniseSession();
        this.status = Transaction.Status.COMMITTED;
    }

    @Override
    public final Transaction.Status status() {
        return this.status;
    }

    @Override
    public void close() {
        this.status = Transaction.Status.CLOSED;
    }

    private void synchroniseSession() {
        for (CypherContext cypherContext : this.contexts) {
            this.logger.debug("Synchronizing transaction context " + cypherContext + " with session context");
            for (Object o : cypherContext.log()) {
                this.logger.debug("checking cypher context object: " + o);
                if (o instanceof MappedRelationship) {
                    MappedRelationship mappedRelationship = (MappedRelationship)o;
                    if (mappedRelationship.isActive()) {
                        this.logger.debug("activating (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
                        this.mappingContext.registerRelationship((MappedRelationship)o);
                        continue;
                    }
                    this.logger.debug("de-activating (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
                    this.mappingContext.mappedRelationships().remove(mappedRelationship);
                    continue;
                }
                if (o instanceof TransientRelationship) continue;
                this.logger.debug("remembering " + o);
                this.mappingContext.remember(o);
            }
            this.logger.debug("number of objects: " + cypherContext.log().size());
        }
        this.contexts.clear();
    }
}

