/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.neo4j.ogm.cypher.compiler.CypherContext;
import org.neo4j.ogm.entityaccess.FieldWriter;
import org.neo4j.ogm.mapper.GraphEntityMapper;
import org.neo4j.ogm.mapper.MappedRelationship;
import org.neo4j.ogm.mapper.MappingContext;
import org.neo4j.ogm.mapper.TransientRelationship;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.response.ResponseHandler;
import org.neo4j.ogm.session.response.RowModelResponse;
import org.neo4j.ogm.session.result.GraphRowModel;
import org.neo4j.ogm.session.result.GraphRowResult;
import org.neo4j.ogm.session.result.RowModel;

public class SessionResponseHandler
implements ResponseHandler {
    private final MetaData metaData;
    private final MappingContext mappingContext;

    public SessionResponseHandler(MetaData metaData, MappingContext mappingContext) {
        this.metaData = metaData;
        this.mappingContext = mappingContext;
    }

    @Override
    public <T> Collection<T> loadByProperty(Class<T> type, Neo4jResponse<GraphRowModel> response) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        LinkedHashSet<Long> resultEntityIds = new LinkedHashSet<Long>();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        GraphRowModel graphRowModel = response.next();
        for (GraphRowResult graphRowResult : graphRowModel.getGraphRowResults()) {
            Object[] rowData;
            GraphEntityMapper ogm = new GraphEntityMapper(this.metaData, this.mappingContext);
            ogm.map((Class)type, graphRowResult.getGraph());
            for (Object data : rowData = graphRowResult.getRow()) {
                if (!(data instanceof Number)) continue;
                resultEntityIds.add(((Number)data).longValue());
            }
        }
        response.close();
        if (classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null) {
            for (Long resultEntityId : resultEntityIds) {
                result.add(this.mappingContext.getNodeEntity(resultEntityId));
            }
        } else {
            for (Long resultEntityId : resultEntityIds) {
                result.add(this.mappingContext.getRelationshipEntity(resultEntityId));
            }
        }
        return result;
    }

    @Override
    public void updateObjects(CypherContext context, Neo4jResponse<String> response, ObjectMapper mapper) {
        RowModel rowModel;
        RowModelResponse rowModelResponse = new RowModelResponse(response, mapper);
        String[] variables = rowModelResponse.columns();
        HashMap<String, Long> directRefMap = new HashMap<String, Long>();
        while ((rowModel = rowModelResponse.next()) != null) {
            Object[] results = rowModel.getValues();
            for (int i = 0; i < variables.length; ++i) {
                String variable = variables[i];
                Long identity = Long.parseLong(results[i].toString());
                directRefMap.put(variable, identity);
                Object persisted = context.getNewObject(variable);
                if (persisted == null) continue;
                ClassInfo classInfo = this.metaData.classInfo(persisted);
                Field identityField = classInfo.getField(classInfo.identityField());
                FieldWriter.write(identityField, persisted, identity);
                if (classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null) {
                    this.mappingContext.registerNodeEntity(persisted, identity);
                } else {
                    this.mappingContext.registerRelationshipEntity(persisted, identity);
                }
                this.mappingContext.remember(persisted);
            }
        }
        if (directRefMap.size() > 0) {
            for (Object object : context.log()) {
                if (!(object instanceof TransientRelationship)) continue;
                MappedRelationship relationship = ((TransientRelationship)object).convert(directRefMap);
                if (this.mappingContext.getRelationshipEntity(relationship.getRelationshipId()) == null) {
                    relationship.setRelationshipId(null);
                }
                this.mappingContext.mappedRelationships().add(relationship);
            }
        }
        rowModelResponse.close();
    }

    @Override
    public <T> T loadById(Class<T> type, Neo4jResponse<GraphModel> response, Long id) {
        GraphModel graphModel;
        GraphEntityMapper ogm = new GraphEntityMapper(this.metaData, this.mappingContext);
        while ((graphModel = response.next()) != null) {
            ogm.map((Class)type, graphModel);
        }
        response.close();
        return this.lookup(type, id);
    }

    private <T> T lookup(Class<T> type, Long id) {
        ClassInfo typeInfo = this.metaData.classInfo(type.getName());
        Object ref = typeInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null ? this.mappingContext.getNodeEntity(id) : this.mappingContext.getRelationshipEntity(id);
        try {
            return type.cast(ref);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Neo4jResponse<GraphModel> response) {
        GraphModel graphModel;
        LinkedHashSet objects = new LinkedHashSet();
        GraphEntityMapper ogm = new GraphEntityMapper(this.metaData, this.mappingContext);
        while ((graphModel = response.next()) != null) {
            objects.addAll(ogm.map((Class)type, graphModel));
        }
        response.close();
        return objects;
    }
}

