/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.QueryStatistics;
import org.neo4j.ogm.session.result.RowQueryStatisticsResult;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowStatisticsResponse
implements Neo4jResponse<RowQueryStatisticsResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowStatisticsResponse.class);
    private final ObjectMapper objectMapper;
    private final Neo4jResponse<String> response;
    private String[] columns;

    public RowStatisticsResponse(Neo4jResponse<String> response, ObjectMapper mapper) {
        this.response = response;
        this.objectMapper = mapper;
        try {
            this.initialiseScan(Neo4jResponse.ResponseRecord.RESULTS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public RowQueryStatisticsResult next() {
        String json = this.response.next();
        if (json != null) {
            try {
                RowQueryStatisticsResult rowQueryStatisticsResult = new RowQueryStatisticsResult();
                JSONObject jsonObject = this.getOuterObject(json);
                JSONArray columnsObject = jsonObject.getJSONArray("results").getJSONObject(0).getJSONArray("columns");
                this.columns = (String[])this.objectMapper.readValue(columnsObject.toString(), String[].class);
                JSONArray dataObject = jsonObject.getJSONArray("results").getJSONObject(0).getJSONArray("data");
                JSONObject statsJson = jsonObject.getJSONArray("results").getJSONObject(0).getJSONObject("stats");
                rowQueryStatisticsResult.setStats((QueryStatistics)this.objectMapper.readValue(statsJson.toString(), QueryStatistics.class));
                ArrayList<Object> rows = new ArrayList<Object>();
                for (int i = 0; i < dataObject.length(); ++i) {
                    String rowJson = dataObject.getJSONObject(i).getString("row");
                    Object row = this.objectMapper.readValue(rowJson, Object.class);
                    rows.add(row);
                }
                rowQueryStatisticsResult.setRows(rows);
                return rowQueryStatisticsResult;
            }
            catch (Exception e) {
                LOGGER.error("failed to parse: " + json);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.response.close();
    }

    @Override
    public void initialiseScan(Neo4jResponse.ResponseRecord record) {
        this.response.initialiseScan(record);
    }

    @Override
    public String[] columns() {
        return this.columns;
    }

    @Override
    public int rowId() {
        return -1;
    }

    private JSONObject getOuterObject(String json) throws JSONException {
        JSONObject outerObject;
        try {
            outerObject = new JSONObject(json);
        }
        catch (JSONException e) {
            outerObject = new JSONObject(json + "]}");
        }
        return outerObject;
    }
}

