/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.ResultProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResponse
implements Neo4jResponse<String> {
    private static final String COMMA = ",";
    private static final String START_RECORD_TOKEN = "{";
    private static final String NEXT_RECORD_TOKEN = ",{";
    private static final String ERRORS_TOKEN = "],\"errors";
    private static final String COMMIT_ERRORS_TOKEN = "},\"errors";
    private static final String COLUMNS_TOKEN = "{\"columns";
    private static final String GRAPH_TOKEN = "\"graph";
    private static final String ROW_TOKEN = "\"row";
    private static final String RESULTS_TOKEN = "\"results";
    private static final String STATS_TOKEN = "\"stats";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResponse.class);
    private final InputStream results;
    private final Scanner scanner;
    private final CloseableHttpResponse response;
    private String scanToken = null;
    private String[] columns;
    private int currentRow = -1;

    public JsonResponse(CloseableHttpResponse response) {
        try {
            this.response = response;
            this.results = response.getEntity().getContent();
            this.scanner = new Scanner(this.results, "UTF-8");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public JsonResponse(InputStream inputStream) {
        this.response = null;
        this.results = inputStream;
        this.scanner = new Scanner(this.results, "UTF-8");
    }

    @Override
    public void initialiseScan(Neo4jResponse.ResponseRecord record) {
        this.scanToken = this.extractToken(record);
        this.scanner.useDelimiter(this.scanToken);
        this.parseColumns();
    }

    @Override
    public String next() {
        try {
            String json = this.scanner.next();
            while (!json.endsWith(NEXT_RECORD_TOKEN)) {
                try {
                    String rest = this.scanner.next();
                    json = json + this.scanToken + rest;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            if (json.endsWith(NEXT_RECORD_TOKEN)) {
                json = json.substring(0, json.length() - NEXT_RECORD_TOKEN.length());
            } else if (json.contains(ERRORS_TOKEN)) {
                int errorsPosition = json.indexOf(ERRORS_TOKEN);
                if (json.substring(errorsPosition).contains("[]")) {
                    json = json.substring(0, errorsPosition);
                } else {
                    this.parseErrors(json);
                }
            }
            String record = START_RECORD_TOKEN + this.scanToken + json;
            ++this.currentRow;
            return record;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.results.close();
            if (this.response != null) {
                LOGGER.debug("Closing HttpResponse");
                this.response.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] columns() {
        return this.columns;
    }

    @Override
    public int rowId() {
        return this.currentRow;
    }

    private void parseColumns() {
        String header = this.scanner.next();
        int cp = header.indexOf(COLUMNS_TOKEN);
        if (cp == -1) {
            this.parseErrors(header);
        } else {
            String colStart = header.substring(cp);
            this.columns = colStart.substring(colStart.indexOf("[") + 1, colStart.indexOf("]")).replace("\"", "").split(COMMA);
        }
    }

    private void parseErrors(String header) {
        int cp = header.indexOf(ERRORS_TOKEN);
        if (cp == -1) {
            cp = header.indexOf(COMMIT_ERRORS_TOKEN);
        }
        if (cp == -1) {
            throw new RuntimeException("Unexpected problem! Cypher response starts: " + header + "...");
        }
        StringBuilder sb = new StringBuilder(header);
        try {
            String response;
            while ((response = this.scanner.next()) != null) {
                sb.append(response);
            }
        }
        catch (Exception e) {
            this.scanner.close();
        }
        throw new ResultProcessingException(sb.substring(cp + 2), null);
    }

    private String extractToken(Neo4jResponse.ResponseRecord format) {
        switch (format) {
            case GRAPH: {
                return GRAPH_TOKEN;
            }
            case ROW: {
                return ROW_TOKEN;
            }
            case RESULTS: {
                return RESULTS_TOKEN;
            }
            case STATS: {
                return STATS_TOKEN;
            }
        }
        throw new RuntimeException("Unhandled response format: " + (Object)((Object)format));
    }
}

