/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.GraphRowModel;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphRowModelResponse
implements Neo4jResponse<GraphRowModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphRowModelResponse.class);
    private final ObjectMapper objectMapper;
    private final Neo4jResponse<String> response;

    public GraphRowModelResponse(Neo4jResponse<String> response, ObjectMapper objectMapper) {
        this.response = response;
        this.objectMapper = objectMapper;
        try {
            this.initialiseScan(Neo4jResponse.ResponseRecord.RESULTS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public GraphRowModel next() {
        String json = this.response.next();
        if (json != null) {
            try {
                GraphRowModel graphRowModel = new GraphRowModel();
                JSONObject jsonObject = this.getOuterObject(json);
                JSONArray dataObject = jsonObject.getJSONArray("results").getJSONObject(0).getJSONArray("data");
                for (int i = 0; i < dataObject.length(); ++i) {
                    String graphJson = dataObject.getJSONObject(i).getString("graph");
                    String rowJson = dataObject.getJSONObject(i).getString("row");
                    GraphModel graphModel = (GraphModel)this.objectMapper.readValue(graphJson, GraphModel.class);
                    Object[] rows = (Object[])this.objectMapper.readValue(rowJson, Object[].class);
                    graphRowModel.addGraphRowResult(graphModel, rows);
                }
                return graphRowModel;
            }
            catch (Exception e) {
                LOGGER.error("failed to parse: " + json);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.response.close();
    }

    @Override
    public void initialiseScan(Neo4jResponse.ResponseRecord record) {
        this.response.initialiseScan(record);
    }

    @Override
    public String[] columns() {
        return this.response.columns();
    }

    @Override
    public int rowId() {
        return this.response.rowId();
    }

    private JSONObject getOuterObject(String json) throws JSONException {
        JSONObject outerObject;
        try {
            outerObject = new JSONObject(json);
        }
        catch (JSONException e) {
            outerObject = new JSONObject(json + "]}");
        }
        return outerObject;
    }
}

