/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.GraphModelResult;
import org.neo4j.ogm.session.result.ResultProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphModelResponse
implements Neo4jResponse<GraphModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphModelResponse.class);
    private final ObjectMapper objectMapper;
    private final Neo4jResponse<String> response;

    public GraphModelResponse(Neo4jResponse<String> response, ObjectMapper mapper) {
        this.response = response;
        this.objectMapper = mapper;
        try {
            this.initialiseScan(Neo4jResponse.ResponseRecord.GRAPH);
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not initialise response", e);
        }
    }

    @Override
    public GraphModel next() {
        String json = this.response.next();
        if (json != null) {
            try {
                return ((GraphModelResult)this.objectMapper.readValue(json, GraphModelResult.class)).getGraph();
            }
            catch (Exception e) {
                LOGGER.error("failed to parse: " + json);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.response.close();
    }

    @Override
    public void initialiseScan(Neo4jResponse.ResponseRecord record) {
        this.response.initialiseScan(record);
    }

    @Override
    public String[] columns() {
        return this.response.columns();
    }

    @Override
    public int rowId() {
        return this.response.rowId();
    }
}

