/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.GraphModelQuery;
import org.neo4j.ogm.cypher.query.GraphRowModelQuery;
import org.neo4j.ogm.cypher.query.Query;
import org.neo4j.ogm.exception.InvalidDepthException;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class VariableDepthRelationshipQuery
implements QueryStatements {
    @Override
    public Query findOne(Long id, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (max > 0) {
            String qry = String.format("MATCH (n)-[r]->() WHERE ID(r) = { id } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new GraphModelQuery(qry, Utils.map("id", id));
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public Query findAll(Collection<Long> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (max > 0) {
            String qry = String.format("MATCH (n)-[r]->() WHERE ID(r) IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new GraphModelQuery(qry, Utils.map("ids", ids));
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public Query findAllByType(String type, Collection<Long> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (max > 0) {
            String qry = String.format("MATCH (n)-[r:`%s`]->() WHERE ID(r) IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", type, min, max);
            return new GraphModelQuery(qry, Utils.map("ids", ids));
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public Query findAll() {
        return new GraphModelQuery("MATCH p=()-->() RETURN p", Utils.map(new Object[0]));
    }

    @Override
    public Query findByType(String type, int depth) {
        int max = this.max(depth);
        if (max > 0) {
            String qry = String.format("MATCH p=()-[r:`%s`*..%d]-() RETURN p", type, max);
            return new GraphModelQuery(qry, Utils.map(new Object[0]));
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    @Override
    public Query findByProperties(String type, Filters parameters, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (max > 0) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            StringBuilder query = VariableDepthRelationshipQuery.constructQuery(type, parameters, properties);
            query.append(String.format("WITH n,r MATCH p=(n)-[*%d..%d]-() RETURN p, ID(r)", min, max));
            return new GraphRowModelQuery(query.toString(), properties);
        }
        throw new InvalidDepthException("Cannot load a relationship entity with depth 0 i.e. no start or end node");
    }

    private static StringBuilder constructQuery(String type, Filters filters, Map<String, Object> properties) {
        ArrayList<Filter> startNodeFilters = new ArrayList<Filter>();
        ArrayList<Filter> endNodeFilters = new ArrayList<Filter>();
        ArrayList<Filter> relationshipFilters = new ArrayList<Filter>();
        String startNodeLabel = null;
        String endNodeLabel = null;
        for (Filter filter : filters) {
            if (filter.isNested()) {
                if (filter.getBooleanOperator().equals((Object)BooleanOperator.OR)) {
                    throw new UnsupportedOperationException("OR is not supported for nested properties on a relationship entity");
                }
                if (filter.getRelationshipDirection().equals("OUTGOING")) {
                    if (startNodeLabel == null) {
                        startNodeLabel = filter.getNestedEntityTypeLabel();
                        filter.setBooleanOperator(BooleanOperator.NONE);
                    }
                    startNodeFilters.add(filter);
                    continue;
                }
                if (endNodeLabel == null) {
                    endNodeLabel = filter.getNestedEntityTypeLabel();
                    filter.setBooleanOperator(BooleanOperator.NONE);
                }
                endNodeFilters.add(filter);
                continue;
            }
            if (relationshipFilters.size() == 0) {
                filter.setBooleanOperator(BooleanOperator.NONE);
            }
            relationshipFilters.add(filter);
        }
        StringBuilder query = new StringBuilder();
        VariableDepthRelationshipQuery.createNodeMatchSubquery(properties, startNodeFilters, startNodeLabel, query, "n");
        VariableDepthRelationshipQuery.createNodeMatchSubquery(properties, endNodeFilters, endNodeLabel, query, "m");
        VariableDepthRelationshipQuery.createRelationSubquery(type, properties, relationshipFilters, query);
        return query;
    }

    private static void createRelationSubquery(String type, Map<String, Object> properties, List<Filter> relationshipFilters, StringBuilder query) {
        query.append(String.format("MATCH (n)-[r:`%s`]->(m) ", type));
        if (relationshipFilters.size() > 0) {
            query.append("WHERE ");
            VariableDepthRelationshipQuery.appendFilters(relationshipFilters, "r", query, properties);
        }
    }

    private static void createNodeMatchSubquery(Map<String, Object> properties, List<Filter> nodeFilters, String nodeLabel, StringBuilder query, String nodeIdentifier) {
        if (nodeLabel != null) {
            query.append(String.format("MATCH (%s:`%s`) WHERE ", nodeIdentifier, nodeLabel));
            VariableDepthRelationshipQuery.appendFilters(nodeFilters, nodeIdentifier, query, properties);
        }
    }

    private static void appendFilters(List<Filter> filters, String nodeIdentifier, StringBuilder query, Map<String, Object> properties) {
        for (Filter filter : filters) {
            if (!filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                query.append(filter.getBooleanOperator().getValue()).append(" ");
            }
            String uniquePropertyName = filter.getPropertyName();
            if (filter.isNested()) {
                uniquePropertyName = filter.getNestedPropertyName() + "_" + filter.getPropertyName();
            }
            query.append(String.format("%s.`%s` %s { `%s` } ", nodeIdentifier, filter.getPropertyName(), filter.getComparisonOperator().getValue(), uniquePropertyName));
            properties.put(uniquePropertyName, filter.getPropertyValue());
        }
    }

    private int min(int depth) {
        return Math.min(0, depth);
    }

    private int max(int depth) {
        return Math.max(0, depth);
    }
}

