/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.query.GraphRowModelQuery;
import org.neo4j.ogm.cypher.query.Query;
import org.neo4j.ogm.cypher.query.RowModelQuery;
import org.neo4j.ogm.cypher.query.RowModelQueryWithStatistics;
import org.neo4j.ogm.cypher.statement.ParameterisedStatement;
import org.neo4j.ogm.cypher.statement.ParameterisedStatements;
import org.neo4j.ogm.metadata.MappingException;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.request.Neo4jRequest;
import org.neo4j.ogm.session.request.RequestHandler;
import org.neo4j.ogm.session.response.EmptyResponse;
import org.neo4j.ogm.session.response.GraphModelResponse;
import org.neo4j.ogm.session.response.GraphRowModelResponse;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.response.RowModelResponse;
import org.neo4j.ogm.session.response.RowStatisticsResponse;
import org.neo4j.ogm.session.result.GraphRowModel;
import org.neo4j.ogm.session.result.RowModel;
import org.neo4j.ogm.session.result.RowQueryStatisticsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionRequestHandler
implements RequestHandler {
    private final ObjectMapper mapper;
    private final Neo4jRequest<String> request;
    private final Logger logger = LoggerFactory.getLogger(SessionRequestHandler.class);

    public SessionRequestHandler(ObjectMapper mapper, Neo4jRequest<String> request) {
        this.request = request;
        this.mapper = mapper;
    }

    @Override
    public Neo4jResponse<GraphModel> execute(Query query, String url) {
        ArrayList<ParameterisedStatement> list = new ArrayList<ParameterisedStatement>();
        list.add(query);
        Neo4jResponse<String> response = this.execute(list, url);
        return new GraphModelResponse(response, this.mapper);
    }

    @Override
    public Neo4jResponse<RowModel> execute(RowModelQuery query, String url) {
        ArrayList<ParameterisedStatement> list = new ArrayList<ParameterisedStatement>();
        list.add(query);
        Neo4jResponse<String> response = this.execute(list, url);
        return new RowModelResponse(response, this.mapper);
    }

    @Override
    public Neo4jResponse<GraphRowModel> execute(GraphRowModelQuery query, String url) {
        ArrayList<ParameterisedStatement> list = new ArrayList<ParameterisedStatement>();
        list.add(query);
        Neo4jResponse<String> response = this.execute(list, url);
        return new GraphRowModelResponse(response, this.mapper);
    }

    @Override
    public Neo4jResponse<String> execute(ParameterisedStatement statement, String url) {
        ArrayList<ParameterisedStatement> list = new ArrayList<ParameterisedStatement>();
        list.add(statement);
        return this.execute(list, url);
    }

    @Override
    public Neo4jResponse<RowQueryStatisticsResult> execute(RowModelQueryWithStatistics query, String url) {
        ArrayList<ParameterisedStatement> list = new ArrayList<ParameterisedStatement>();
        list.add(query);
        Neo4jResponse<String> response = this.execute(list, url);
        return new RowStatisticsResponse(response, this.mapper);
    }

    @Override
    public Neo4jResponse<String> execute(List<ParameterisedStatement> statementList, String url) {
        try {
            String json = this.mapper.writeValueAsString((Object)new ParameterisedStatements(statementList));
            if (!json.contains("statement\":\"\"")) {
                this.logger.debug(json);
                return this.request.execute(url, json);
            }
            return new EmptyResponse();
        }
        catch (JsonProcessingException jpe) {
            throw new MappingException("Could not create JSON due to " + jpe.getLocalizedMessage(), (Exception)((Object)jpe));
        }
    }
}

